/*
 * StepPatternInstance.cpp
 *
 *  Created on: 2009/10/06
 *      Author: ox
 */

#include "StepPatternInstance.h"
#include "common.h"

//! static
vector<StepPattern*> StepPatternInstance::patterns;

StepPattern *StepPatternInstance::at(unsigned int num) {
	if(num < patterns.size()) {
		return patterns.at(num);
	}
	return patterns.at(0);
}

//! Xebvp^[쐬
void StepPatternInstance::init() {

	StepPattern *pat = new StepPattern(16, "4beat");
	pat->set(	0, 	1, 	1, 	1);
	pat->set(	4, 	1, 	1, 	1);
	pat->set(	8, 	1, 	1, 	1);
	pat->set(	12, 1, 	1, 	1);
	patterns.push_back(pat);

	pat = new StepPattern(16, "4beat-2 ");
	pat->set(	0, 	1, 	1, 	1);
	pat->set(	3, 	1, 	1, 	1);
	pat->set(	6, 	1, 	1, 	1);
	pat->set(	8, 	1, 	1, 	1);
	pat->set(	12, 1, 	1, 	1);
	patterns.push_back(pat);

	pat = new StepPattern(16, "4beat-3 ");
	pat->set(	0, 	1, 	1, 	1);
	pat->set(	3, 	1, 	1, 	1);
	pat->set(	4, 	1, 	1, 	1);
	pat->set(	6, 	1, 	1, 	1);
	pat->set(	8, 	1, 	1, 	1);
	pat->set(	9, 1, 	1, 	1);
	pat->set(	11, 1, 	1, 	1);
	pat->set(	13, 1, 	1, 	1);
	patterns.push_back(pat);

	pat = new StepPattern(16, "4beat 2duration");
	pat->set(0, 1, 	2, 	1);
	pat->set(4, 1, 	2, 	1);
	pat->set(8, 1, 	2, 	1);
	pat->set(12, 1,	2, 	1);
	patterns.push_back(pat);

	pat = new StepPattern(16, "4beat 4duration");
	pat->set(0, 1, 	4, 	1);
	pat->set(4, 1, 	4, 	1);
	pat->set(8, 1, 	4, 	1);
	pat->set(12, 1,	4, 	1);
	patterns.push_back(pat);

	pat = new StepPattern(16, "8beat ");
	pat->set(	0, 	1, 	1, 	1);
	pat->set(	2, 	1, 	1, 	1);
	pat->set(	4, 	1, 	1, 	1);
	pat->set(	6, 	1, 	1, 	1);
	pat->set(	8,  1, 	1, 	1);
	pat->set(	10,  1,	1, 	1);
	pat->set(	12,  1,	1, 	1);
	pat->set(	14,  1,	1, 	1);
	patterns.push_back(pat);

	pat = new StepPattern(16, "8beat-2 ");
	pat->set(	0, 	1, 	1, 	1);
	pat->set(	2, 	1, 	1, 	1);
	pat->set(	4, 	1, 	1, 	1);
	pat->set(	6, 	1, 	1, 	1);
	pat->set(	7, 	1, 	1, 	1);
	pat->set(	9,  1, 	1, 	1);
	pat->set(	10,  1,	1, 	1);
	pat->set(	12,  1,	1, 	1);
	pat->set(	14,  1,	1, 	1);
	patterns.push_back(pat);




}




