/*
 * StepPatternList.h
 *
 *  Created on: 2009/10/07
 *      Author: ox
 */

#ifndef STEPPATTERNLIST_H_
#define STEPPATTERNLIST_H_

#include "StepPattern.h"
#include "StepPatternDraw.h"
#include "Layout.h"

#include "graphic/text/ftlabel.h"

class StepPatternListDraw {
public:
	StepPatternListDraw(float posx, float posy, UnitMng *mng, vector<StepPattern*> &patterns);
	virtual ~StepPatternListDraw();

	void grub(float x, float y);
	void move(float x, float y);
	StepPattern *release(float x, float y);
	StepPattern *getHighlightPattern() { return highlightPattern; }

private:
	void moveListItems(float my);
	void makeList();
	void eraseList();

	struct StepPatternDrawSet {
		StepPattern *pattern;
		StepPatternDraw *patternDraw;
		ftlabel *patternLabel;
		float size;
		StepPatternDrawSet(StepPattern *pattern, float x, float y, UnitMng *mng) : pattern(pattern) {
			patternLabel = new ftlabel(pattern->getName(), FTGL_PIXMAP,
					Layout::stepPatternListLabelSize, x, y);
			patternDraw = new StepPatternDraw(pattern, x, y + Layout::stepPatternListLabelRectMargin,
					Layout::stepPatternListRectSize, Layout::stepPatternListRectsRatio, mng);
			GlutMain::addUnit(patternLabel);
		}

		~StepPatternDrawSet() {
			patternLabel->die();
			delete patternDraw;
		}

		void movey(float my) {
			patternDraw->movey(my);
			patternLabel->setY(patternLabel->getY() + my);
		}

		bool highlightDetection(float highlightPosition) {
			float ly = patternLabel->getY();
			if(((highlightPosition - Layout::stepPatternListItemSize*0.5) < ly) &&
					(ly < (highlightPosition + Layout::stepPatternListItemSize*0.5))) {
				patternDraw->setColor(Layout::StepPatternListHighlightColor);
				patternLabel->setColor(Layout::StepPatternListHighlightColor);
				patternLabel->setSize(Layout::stepPatternListLabelSize + 0.01);
				return true;
			} else {
				patternDraw->setColor(Layout::StepPatternListColor);
				patternLabel->setColor(Layout::StepPatternListColor);
				patternLabel->setSize(Layout::stepPatternListLabelSize);
				return false;
			}
		}
	};

	float posx, posy;
	UnitMng *mng;
	vector<StepPatternDrawSet*> patternSet;
	vector<StepPattern*> &patterns;
	vector<StepPatternDraw*> patternDraw;
	StepPattern *highlightPattern;

	float grubx, gruby;
	float movex, movey;
	float sumMoveY;
	float lastStepY;
	bool grubbing;
};

typedef struct StepPatternDrawSet StepPatternDrawSet;

#endif /* STEPPATTERNLIST_H_ */
