#ifndef __COMMON__
#define __COMMON__

#include <iostream>
#include <sstream>
#include <string>
#include <iomanip>
#include <math.h>
#include <vector>
#include <list>
#include <fstream>
#include <stdio.h>
#include <GLUT/glut.h>

#include "debug.h"
#include "Stk.h"

using namespace std;

// Definition for Synth
#define SAMPLING_RATE 			48000
#define DELTA_CONTROL_TICKS 	256 // default sample frames between control input checks
#define DEFAULT_TEMPO 			120
#define DEFAULT_DIAC 			4

// Definition for Graphic
#define Pi 3.14159265358979f
#ifndef TWO_PI
#define TWO_PI 6.28318530717958f
#endif
#define Glut_WINDOW_DEFAULT_WIDTH  640
#define Glut_WINDOW_DEFAULT_HEIGHT 480
#define TTF_DATA_PATH "./data/ttf"
//#define RADIUS           70.0
//#define DIST_BALL       (RADIUS * 2.0 + RADIUS * 0.1)
//#define VIEW_SCENE_DIST (DIST_BALL * 3.0+ 200.0)/* distance from viewer to middle of boing area */
//#define FFT_SIZE 4096

// common var
extern float rand_over;

// normalized random value
inline float nrand()
{
	return rand() * rand_over;
}

inline float distance(float startx, float starty, float endx, float endy) {
	return (float)(sqrt((endx - startx)*(endx - startx) + (endy - starty)*(endy - starty)));
}

// startup API
void graphic_main(int argc, char *argv[]);
void graphic_start();
void graphic_release();

void sound_main(int argc, char *argv[]);
void sound_start();
void sound_release();

#endif
