/*
 * CtrlMovingRubber.h
 *
 *  Created on: 2009/04/04
 *      Author: sambuichi
 */

#ifndef CTRLMOVINGRUBBER_H_
#define CTRLMOVINGRUBBER_H_

#include "ctrl/Param.h"
#include "common/Mutex.h"
#include "graphic/AppForm.h"
#include "graphic/port/Positionable.h"
#include "graphic/port/Resizable.h"
#include "graphic/primitive/Circle.h"
#include "graphic/primitive/Rect.h"

class CtrlMovingRubber: public AppForm {
public:
	CtrlMovingRubber();
	virtual ~CtrlMovingRubber();

	void draw();
	void mousePosition(int x, int y);
	void mouseFunction(int x, int y, int state);
	void keyFunc(int key, int action);

	/*!
	 *	\brief _pointNX
	 */
	class _point : public Positionable, public Resizable {
	public:
		_point() : xv(0), yv(0), zv(0), fric(0), state(0), drawing(0) {}
		float xv, yv, zv;
		float fric;
		bool rollover;
		unsigned char state;
		Circle *drawing;
		bool inArea(float nx, float ny) {
			float left = getX() - getSize() * 0.35;
			float right = getX() + getSize() * 0.35;
			float top = getY() + getSize() * 0.35;
			float bottum = getY() - getSize() * 0.35;
			if(left <= nx && nx <= right &&
					bottum <= ny && ny <= top) {
				return true;
			}
			return false;
		}
	};

	class _line {
	public:
		_line() : length(0.2), length_over(5), spring(0.05), p1(0), p2(0) {}
		float length;
		float length_over;
		float spring;
		_point *p1, *p2;
	};

	_point *addPoint(float x, float y, float fric, float xv, float yv);
	_line *addLine(_point *p1, _point *p2, float length, float spring);

	void deletePoints();
	void deleteLines();
	void deleteAll();

private:
	vector<_point*> points;
	vector<_line*> lines;

	Mutex mutex;
	_point *focusedPoint;

	const static unsigned char rollover = 0x01;
	const static unsigned char selected = 0x02;

	const static unsigned char moveStop = 0x01;
	unsigned char flag;

	Param spring;
};

#endif /* CTRLMOVINGRUBBER_H_ */
