/*
 * CtrlV.cpp
 *
 *  Created on: 2009/02/07
 *      Author: sambuichi
 */

#include "CtrlV.h"
#include "graphic/GlutMain.h"
#include "graphic/primitive/Rect.h"
#include "graphic/Updater/UpdaterKillUnit.h"

CtrlV::CtrlV() :
	vs1(0, 0.2, 2),
	vs2(0.3, 0.8, 5),
	vs3(0.3, 0.8, 5),
	shapes(36),
#ifdef _FTGL_ENABLE_
	pm(15, this),
#endif
	mouse_rotate_flag(0)
{
	DeclareName;
	dcnt = 0;
}

CtrlV::~CtrlV() {

}

void CtrlV::update() {
	if(!active) return;

#ifdef _FTGL_ENABLE_
	pm.labelStart();
	pm.addLabel("[CTRL + mouseX, mouseY]");
	pm.addLabel("vs1 min=", vs1.min);
	pm.addLabel("vs1 max=", vs1.max);
	pm.addLabel("[ALT + mouseX, mouseY]");
	pm.addLabel("vs2 min=", vs2.min);
	pm.addLabel("vs2 max=", vs2.max);
	pm.addLabel("[SHIFT + mouseX, mouseY]");
	pm.addLabel("vs3 min=", vs3.min);
	pm.addLabel("vs3 max=", vs3.max);
	pm.addLabel("[CTRL + ALT + mouseX, mouseY]");
	pm.addLabel("vs1 T=", vs1.T);
	pm.addLabel("vs2 T=", vs2.T);
	pm.addLabel("vs3 T=", vs3.T);
	pm.addLabel("[CTRL + SHIFT + mouseX, mouseY]");
	pm.addLabel("num=", shapes.num);
	pm.addLabel("[SPACE + mouseX, mouseY]");
	pm.addLabel("object rotate X=", rx);
	pm.addLabel("object rotate Y=", ry);
#endif
}

void CtrlV::draw() {
	if(!active) return;

	int i = 0;

	Shape *r = new Rect();
	r->setPos(mx, my, 0.5);
	r->setColor(1, 0, 0, 0.5);
	r->updateDelete(10);
	addUnit((Unit*)r);

	glDisable(GL_CULL_FACE);
	if(mouse_rotate_flag) {
		rx = mx * 360;
		ry = my * 360;
	}
	glRotatef(rx, 1, 0, 0);
	glRotatef(ry, 0, 1, 0);

	shapes.lock();
	float num_over = shapes.num_over;
	for(vector<Shape*>::iterator itr = shapes.begin(); itr < shapes.end(); itr++) {
		glPushMatrix();

		float rot = (dcnt * 360 * framerate_over * 0.1) + (360 * num_over * i++);
		glRotatef(rot, 0, 0, 1);

		Shape *shape = (Shape*) *itr;
		float v1 = vs1.t(dcnt * framerate_over * 0.5 + (i * num_over * vs1.T));
		float v2 = vs2.t(dcnt * framerate_over * 0.5 + (i * num_over * vs2.T));
		float v3 = vs3.t(dcnt * framerate_over * 0.5 + (i * num_over * vs3.T));
		shape->setPos(v1, v2, v3);

		shape->update();
		shape->draw();

		glPopMatrix();
	}
	shapes.unlock();

	dcnt++;
}

void CtrlV::mousePosition(int x, int y)
{
	bool ctrl  = KeyMng::getInstance()->CTRL;
	bool alt   = KeyMng::getInstance()->ALT;
	bool shift = KeyMng::getInstance()->SHIFT;
	mx = mousex() * width_over;
	my = mousey() * height_over;

	if(ctrl && alt) {
		vs1.T = mx * 8;
		vs2.T = my * 8;
	} else if(ctrl && shift) {
		shapes.build((int)(my * 128));
	} else if(ctrl) {
		vs1.min = mx;
		vs1.max = my;
	} else if(alt) {
		vs2.min = mx;
		vs2.max = my;
	} else if(shift) {
		vs3.min = mx;
		vs3.max = my;
	}
}

void CtrlV::setActive(bool active) {
	this->active = active;
#ifdef _FTGL_ENABLE_
	pm.setActive(active);
#endif
}

void CtrlV::keyFunc(int key, int action) {
	if(key == KEY_SPACE) {
		mouse_rotate_flag = action;
	}
}

