/*
 * RectVector.cpp
 *
 *  Created on: 2009/02/09
 *      Author: sambuichi
 */

#include "ShapeVector.h"
#include "graphic/primitive/Rect.h"
#include "graphic/primitive/Circle.h"

ShapeVector::ShapeVector(int num, SHAPE_TYPE type) : type(type) {
	build(num);
}

ShapeVector::~ShapeVector() {
	int cnt = 0;
 	for(vector<Shape*>::iterator itr = shapes.begin(); itr != shapes.end();) {
 		shapes.erase(itr);
 		cout << __FILE__ << " : erase shape vector item " << cnt++ << endl;
 		delete (Shape*)*itr;
 	}
}

void ShapeVector::build(int num) {
	lock();
	if(num > this->num) {
		for(int i = 0; i < (num - this->num); i++){
			switch(type) {
			case SHAPE_RECT:
				shapes.push_back(new Rect());
				break;
			case SHAPE_CIRCLE:
				shapes.push_back(new Circle());
				break;
			}
		}
	}
	num_over = 1.0 / (float)num;
	this->num = num;
	unlock();
}

vector<Shape*>::iterator ShapeVector::begin()
{
	return shapes.begin();
}

vector<Shape*>::iterator ShapeVector::end()
{
	return shapes.end();
}

void ShapeVector::lock() { mutex.lock(); }
void ShapeVector::unlock() { mutex.unlock(); }
