/*
 * RectVector.h
 *
 *  Created on: 2009/02/09
 *      Author: sambuichi
 */

#ifndef RECTVECTOR_H_
#define RECTVECTOR_H_

#include "common.h"
#include "graphic/primitive/Shape.h"

typedef enum {
	SHAPE_RECT,
	SHAPE_CIRCLE,
} SHAPE_TYPE;

/*!
 * \brief ShapeArray
 * w肵ShapeꊇŐ
 * ꍇ͒ǉ邪AĂ폜Ȃinumς邾j
 * EShape̐
 * EShape̔rANZXpZ}tH
 */
class ShapeVector {
public:
	ShapeVector(int num, SHAPE_TYPE type = SHAPE_RECT);
	virtual ~ShapeVector();

	void build(int num);

	vector<Shape*>::iterator begin();
	vector<Shape*>::iterator end();

	int num;
	float num_over;

	void lock();
	void unlock();

private:
	SHAPE_TYPE type;
	vector<Shape*> shapes;

	Mutex mutex;
};

#endif /* RECTVECTOR_H_ */
