/*
 * CtrlB.cpp
 *
 *  Created on: 2009/02/02
 *      Author: sambuichi
 */

#include "CtrlB.h"
#include "graphic/GlutMain.h"
#include "graphic/unit/ball/Ball.h"
#include "graphic/unit/primitive/Rect.h"
#include "graphic/GraphicWindowMng.h"
#include "UpdaterKillUnit.h"

CtrlB::CtrlB() {
	DeclareName;
	AudioSystem::getMetro()->addMetroListener(this);
	AudioSystem::addTickListener(this);
	GraphicWindowMng::getInstance()->addContents(this, 0);
}

CtrlB::~CtrlB() {
	// TODO Auto-generated destructor stub
}

void CtrlB::init(void)
{
	synth = MakeSynth("Moog", 4);
//	GlutMain::addUnit(ball = new Ball());
//	ball->setFill(true);

	vs.min = 0.2; vs.max = 0.8; vs.d = 0.5 / (float)30;
	vd.d = (vd.max - vd.min) * 0.2 / (float)30;
}

void CtrlB::draw(void)
{
	float _vs = vs.next();
//	float _vs = vs.next();
//	float _vd = rand() * rand_over;

//	ball->x.norm(_vs);
//	ball->y.norm(_vd);
}

void CtrlB::tick(long tickCount)
{
}

void CtrlB::beatEvent() {
	float x = rand() * rand_over;
	float y = rand() * rand_over;
	synth->noteOn(42 + x * 36, 60);
	synth->controlChange(2, 40 + y * 32);

	Shape *r = new Rect();
	r->setPos(x, y, 0.5);
	new UpdaterKillUnit(r, 30);
//	r->setLife(30);
	GlutMain::addUnit(r);

//	ball->x.norm(0.3 + 0.3 * x);
//	ball->y.norm(0.3 + 0.3 * y);

	//		float r = rand() * rand_over;
	//		ball->y.norm(r);
	//		float note = ball->y.norm() * 60 + 40;
	//		synth->noteOn(note, 60);
	//
	//	synth->controlChange(2, vs * 128);
	//	synth->controlChange(4, vd * 128);
}

void CtrlB::metro(unsigned int block, unsigned int beat, unsigned int battuta)
{
	static unsigned int bk = 0xFFFFFFFF;
	static unsigned int bt = 0xFFFFFFFF;
	static bool on = false;

	if(bk != block) {	//! block event
		bk = block;
	}

	if(bt != beat) {	//! beat event
		bt = beat;
		beatEvent();
	}
}
