/*
 * CtrlDoublePendulum.cpp
 *
 *  Created on: 2009/03/24
 *      Author: sambuichi
 */

#include "CtrlDoublePendulum.h"
#include "graphic/primitive/Line.h"
#include "graphic/primitive/ShapeFactory.h"
#include "graphic/updater/UpdaterFactory.h"

const float CtrlDoublePendulum::fadeoutStartValue 	= 0.4;
const int CtrlDoublePendulum::fadeoutNumShowFrame	= 2;
const int CtrlDoublePendulum::fadeoutNumFadeFrame	= 5;

CtrlDoublePendulum::CtrlDoublePendulum() {
	DeclareName
}

CtrlDoublePendulum::~CtrlDoublePendulum() {

}

void CtrlDoublePendulum::addUnitFadeOut(BaseUnit *unit)
{
	UnitForm::addUnitFadeOut(unit, fadeoutStartValue, fadeoutNumShowFrame, fadeoutNumFadeFrame);
}

void CtrlDoublePendulum::draw()
{
	if(!active) return;

	pend.next();
	int *pos = pend.getPos();

	Circle *cir1 = ShapeFactory::smallRedPoint(0, 0);
	Circle *cir2 = ShapeFactory::smallRedPoint(pos[0]*width_over, pos[1]*height_over);
	Circle *cir3 = ShapeFactory::smallRedPoint(pos[2]*width_over, pos[3]*height_over);

	Line *line1 = ShapeFactory::fadeLine(cir1, cir2);
	Line *line2 = ShapeFactory::fadeLine(cir2, cir3);

	addUnitFadeOut(cir1);
	addUnitFadeOut(cir2);
	addUnitFadeOut(cir3);
	addUnitFadeOut(line1);
	addUnitFadeOut(line2);
}

void CtrlDoublePendulum::mousePosition(int x, int y)
{
//	if(drawingLine && mousePressing) {
//		drawingLine->p2->setPos(x*width_over, y*height_over, 0.5);
//	}
}

void CtrlDoublePendulum::mouseFunction(int x, int y, int state)
{

}

