/*
 * CtrlForm.cpp
 *
 *  Created on: 2009/02/07
 *      Author: sambuichi
 */

#include "CtrlForm.h"

#include "graphic/primitive/ShapeFactory.h"
#include "graphic/updater/UpdaterFactory.h"
#include "graphic/primitive/Circle.h"
#include "graphic/primitive/Line.h"

CtrlForm::CtrlForm() {
	AudioSystem::getMetro()->addMetroListener(this);
}

CtrlForm::~CtrlForm() {
	AudioSystem::getMetro()->removeMetroListener(this);
}

void CtrlForm::init(void)
{
}

void CtrlForm::draw(void)
{

}

void CtrlForm::blockEvent(int b)
{

}

void CtrlForm::beatEvent(int b)
{

}

void CtrlForm::battutaEvent(int b)
{

}

void CtrlForm::metro(unsigned int block, unsigned int beat, unsigned int battuta)
{
	static unsigned int bk = 0xFFFFFFFF;
	static unsigned int bt = 0xFFFFFFFF;

	if(bk != block) {	//! block event
		bk = block;
		blockEvent(block);
	}

	if(bt != beat) {	//! beat event
		bt = beat;
		beatEvent(beat);
	}

	battutaEvent(battuta);
}

/*!
 *	\brief eO[vɃjbgǉ
 */
void CtrlForm::addUnit(Unit *unit)
{
	parent->addUnitDelay(unit);
}

/*!
 *	\brief
 */
void CtrlForm::addUnitFadeOut(BaseUnit *unit, const float firstValue, const int numShowingFrame, const int numFadeFrame)
{
	UpdaterFactory::fadeoutUnit(unit, firstValue, numShowingFrame, numFadeFrame);
	addUnit(unit);
}

///*!
// *	\brief
// *	\param ctrl
// *	\param x_pixel
// *	\param y_pixel
// */
//Circle *CtrlForm::createFadeCircle(int x_pixel, int y_pixel) {
//	return createFadeCircle((x_pixel * width_over + 0.5f), (y_pixel * height_over + 0.5f));
//}
//
///*!
// *	\brief
// *	\brief WO`PŎw肵Aʒ0.5ƍl
// *	\brief @XF[O
// *	\brief @YF[O
// *	\param ctrl
// *	\param x_norm
// *	\param y_norm
// */
//Circle *CtrlForm::createFadeCircle(float x_norm, float y_norm) {
//	Circle *circle = ShapeFactory::smallRedPoint(x_norm, y_norm);
//	UpdaterFactory::fadeoutUnit(circle, 0.4, 2, 5);
//	addUnit(circle);
//	return circle;
//}

/*!
 *	\brief
 *	\brief
 */
Line *CtrlForm::createFadeLine(Positionable *p1, Positionable *p2) {
	Line *line = new Line();
//	line->setSize(0.01);				//! Default Size
//	line->setColor(1, 0.5 ,0.5 ,0.4);	//! Default size ȂH
	line->p1 = p1;
	line->p2 = p2;
	UpdaterFactory::fadeoutUnit(line, 0.4, 2, 5);
	addUnit(line);
	return line;
}
