/*
 * CtrlForm.h
 *
 *  Created on: 2009/02/07
 *      Author: sambuichi
 */

#ifndef CTRLFORM_H_
#define CTRLFORM_H_

#include "vdata.h"

#include "graphic/GlutMain.h"
//#include "graphic/GraphicWindowMng.h"
#include "graphic/mng/MouseMng.h"

//#include "audio/AudioSystem.h"
//#include "audio/SynthDefinition.h"
//#include "audio/metro/TempoMetro.h"

#include "graphic/AppForm.h"
#include "graphic/primitive/Shape.h"
#include "graphic/primitive/rect.h"

#include "ctrl/ParamMonitor.h"

class Circle;
class Line;

class CtrlForm :
	public UnitForm,
	public TempoMetroListener
{
public:
	CtrlForm();
	virtual ~CtrlForm();

	void init();
	void draw();
	void metro(unsigned int block, unsigned int beat, unsigned int battuta);

protected:
	virtual void blockEvent(int b);
	virtual void beatEvent(int b);
	virtual void battutaEvent(int b);

	float width;
	float height;
	float width_over;
	float height_over;
	float framerate_over;

	int mousex() {
		return MouseMng::getInstance()->X;
	}
	int mousey() {
		return MouseMng::getInstance()->Y;
	}

	float xmouse2norm(int mousex) {
		return mousex * width_over;
	}

	float ymouse2norm(int mousey) {
		return mousey * height_over;
	}

	void addUnit(Unit *unit);
	void addUnitFadeOut(BaseUnit *unit, const float firstValue = 0.5, const int numShowingFrame = 30, const int numFadeFrame = 10);

	/*!
	 * CtrlFunctions
	 */
//	Circle *createFadeCircle(int x_pixel, int y_pixel);
//	Circle *createFadeCircle(float x, float y);

	Line *createFadeLine(Positionable *p1, Positionable *p2);
};

#endif /* CTRLFORM_H_ */
