/*
 * ShapePool.cpp
 *
 *  Created on: 2009/02/17
 *      Author: sambuichi
 */

#include "ShapePool.h"

ShapePool::ShapePool() :
	num_shape(0), num_shape_over(0) {
	lc = glfwCreateMutex();
}

ShapePool::~ShapePool() {
	int cnt = 0;
	lock();
 	for(vector<Shape*>::iterator itr = shapes.begin(); itr != shapes.end();) {
 		shapes.erase(itr);
 		cout << __FILE__ << " : erase shape pool item " << cnt++ << endl;
 		delete (Shape*)*itr;
 	}
	unlock();
}

void ShapePool::addShape(Shape *s)
{
	lock();

	delayAddShapes.push_back(s);

	unlock();
}

void ShapePool::loopend()
{
	lock();
 	//! DeadԂBaseUnit
 	for(vector<Shape*>::iterator itr = shapes.begin(); itr != shapes.end();) {
 		Shape *shape = (Shape*)*itr;
 		if(shape->isDead()) {
 			shapes.erase(itr);
 			this->num_shape--;
#ifdef DEBUG_MEMORY_LEAK
 			cout << __FILE__ << __LINE__ << " : Erase ShapePool item " << shape->getName() << endl;
#endif
 			delete shape;
 		} else {
 			itr++;
 		}
 	}

 	//! DelayAddxN^ǉ
 	for(vector<Shape*>::iterator itr = delayAddShapes.begin(); itr != delayAddShapes.end(); itr++) {
 		shapes.push_back((Shape*)*itr);
		this->num_shape++;
 	}
 	delayAddShapes.clear();

 	//! shapȇ𔽉f
 	num_shape_over = 1.0 / (float)num_shape;

	unlock();
}

vector<Shape*>::iterator ShapePool::begin()
{
	return shapes.begin();
}

vector<Shape*>::iterator ShapePool::end()
{
	return shapes.end();
}

void ShapePool::lock() { glfwLockMutex(lc); }
void ShapePool::unlock() { glfwUnlockMutex(lc); }
