/*
 * SyList.cpp
 *
 *  Created on: 2009/02/18
 *      Author: sambuichi
 */

#include "SyList.h"
#include "audio/SynthController.h"
#include "graphic/unit/text/ftlabel.h"
#include "graphic/unit/text/FTLabelFactory.h"
#include "graphic/GraphicWindowMng.h"

SyList::SyList() : currentFocusLabel(NULL)
{
	printfunc;
	synthLabelsLock = glfwCreateMutex();
	createSynthLabels();
}

SyList::~SyList() {
	deleteLabels();
}

//! Synthꗗx쐬
void SyList::createSynthLabels()
{
	deleteLabels();	//! ݕ\Ẵxׂč폜

	glfwLockMutex(synthLabelsLock);	//! lock
	SynthController *sc = SynthController::getInstance();
	int numSynth = sc->getEntryNum();

	//! Synth̐x쐬labelsxN^[ɒǉ
	for(int row = 0; row < numSynth; row++) {
		Synth *synth = sc->getSynthAt(row);
		string name = synth->getName();
		ftlabel *ftl = FTLabelFactory::getInstance()->syListLabel(name, row, numSynth);
		labels.push_back(ftl);
		GraphicWindowMng::getInstance()->getMng()->addUnit(ftl, 0);
	}

	//! xЂƂȏ゠Ȃ擪̃xcurrentFocusLabelɐݒ
	if(labels.size() > 0) {
		currentFocusLabel = labels.at(0);
	}
	glfwUnlockMutex(synthLabelsLock);	//! unlock
}

//! SynthPortꗗx쐬
void SyList::createSynthPortLabels(Synth *synth) {
	if(synth != NULL) {
		deleteLabels();	//! ݕ\Ẵxׂč폜

		glfwLockMutex(synthLabelsLock);	//! lock
		int row = 0;
		vector<SynthPort*> &sps = synth->getPorts();
		int numPorts = sps.size();
		for(vector<SynthPort*>::iterator itr = sps.begin(); itr < sps.end(); itr++) {
			SynthPort *sp = (SynthPort*)*itr;
			string name = sp->getName();
			ftlabel *ftl = FTLabelFactory::getInstance()->syListLabel(name, row++, numPorts);
			labels.push_back(ftl);
			GraphicWindowMng::getInstance()->getMng()->addUnit(ftl, 0);
		}
		//! xЂƂȏ゠Ȃ擪̃xcurrentFocusLabelɐݒ
		if(labels.size() > 0) {
			currentFocusLabel = labels.at(0);
		}
		glfwUnlockMutex(synthLabelsLock);	//! unlock
	}
}

//! \̃x폜
void SyList::deleteLabels()
{
	glfwLockMutex(synthLabelsLock);	//! lock
	//! x폜
	for(vector<ftlabel*>::iterator itr = labels.begin(); itr != labels.end(); itr++) {
		((ftlabel*)*itr)->die();
		cout << "ftlabel dead " << __FILE__ << " " << *itr << endl;
	}
	labels.clear();	//! Svf폜

	currentFocusLabel = NULL;	//! ݂̃tH[JXx𖳂ɂ
	glfwUnlockMutex(synthLabelsLock);	//! unlock
}

void SyList::setFocusColor(bool on)
{
	glfwLockMutex(synthLabelsLock);	//! lock
	if(currentFocusLabel != NULL) {
		if(on) {
			currentFocusLabel->setColor(0.9, 0.1, 0.2, 0.7);
		} else {
			currentFocusLabel->setColor(0.5, 0.5, 0.5, 0.5);
		}
	}
	glfwUnlockMutex(synthLabelsLock);	//! unlock
}

//! currentFocusLabellabels̎̃ACeɕύX
void SyList::nextFocusLabel()
{
	glfwLockMutex(synthLabelsLock);	//! lock
	for(vector<ftlabel*>::reverse_iterator itr = labels.rbegin(); itr != labels.rend(); itr++) {
		if(currentFocusLabel == (ftlabel*)*itr) {
			if((itr+1) != labels.rend()) {
				currentFocusLabel = *(itr+1);
				break;
			}
		}
	}
	glfwUnlockMutex(synthLabelsLock);	//! unlock
}

//! currentFocusLabellabels̑ÕACeɕύX
void SyList::prevFocusLabel()
{
	glfwLockMutex(synthLabelsLock);	//! lock
	for(vector<ftlabel*>::iterator itr = labels.begin(); itr != labels.end(); itr++) {
		if(currentFocusLabel == (ftlabel*)*itr) {
			if((itr+1) != labels.end()) {
				currentFocusLabel = *(itr+1);
				break;
			}
		}
	}
	glfwUnlockMutex(synthLabelsLock);	//! unlock
}

void SyList::keyFunc(int key, int action)
{
	switch(key) {
	case GLFW_KEY_UP:	//! ݕ\x̃tH[JXP
		setFocusColor(false);
		nextFocusLabel();
		setFocusColor(true);
		break;
	case GLFW_KEY_DOWN:	//! ݕ\x̃tH[JXP
		setFocusColor(false);
		prevFocusLabel();
		setFocusColor(true);
		break;
	case GLFW_KEY_ENTER:	//! tH[JXĂVZ̃|[gꗗ\ɐ؂ւ
		// TODO VZ\Ԃł΁AƂKvAȂĂiVZƓÕ|[gȂ΁j
		Synth *synth = SynthController::getInstance()->getSynth(currentFocusLabel->getLabel());
		createSynthPortLabels(synth);
		setFocusColor(true);
		break;
	case GLFW_KEY_BACKSPACE:	//! VZꗗ\ɐ؂ւ
		createSynthLabels();
		setFocusColor(true);
	default:
		break;
	}
}

void SyList::focusOn()
{
	printunitfuncfocus;
	setFocusColor(true);
}

void SyList::focusOff()
{
	printunitfuncfocus;
	setFocusColor(false);
}
