#ifndef UNITFORM_H_
#define UNITFORM_H_

#include "UnitForm.h"
#include "graphic/mng/MouseMng.h"
#include "graphic/mng/KeyMng.h"
#include "graphic/mng/UnitMng.h"
#include "graphic/mng/WindowMng.h"

/*!
 * \brief jbg̐`X[p[NX
 *
 * jbg̐`ƂėpB
 * jbgŌpAKvȊ֐݂̂I[o[Ch悤ɂB
 */
class AppForm :
	public UnitForm,
	public UnitMng,
	public MouseListener,
	public KeyInputListener,
	public WindowListener,
	public WindowMng
{
public:
	AppForm();
	virtual ~AppForm();

	virtual void draw();
	virtual void update();

	/* InputListener Method */
	void focusOn();
	void focusOff();
	void keyFunc(int key, int action);
	void mouseFunction(int x, int y, int state);
	void mouseButton(int pos, int state);
	void mousePosition(int x, int y);
	void mouseWheel(int val);
	void windowSizeChanged(int width, int height);

protected:
	float width;
	float height;
	float width_over;
	float height_over;
	float framerate_over;

	int mousex() {
		return MouseMng::getInstance()->X;
	}
	int mousey() {
		return MouseMng::getInstance()->Y;
	}

	float mousenx() {
		return MouseMng::getInstance()->X * width_over;
	}

	float mouseny() {
		return MouseMng::getInstance()->Y * height_over;
	}

	float xmouse2norm(int mousex) {
		return mousex * width_over;
	}

	float ymouse2norm(int mousey) {
		return mousey * height_over;
	}

	//! PixellłƂāAl͐KO`PŕԂ
	float distancei(int startx, int starty, int endx, int endy) {
		return distance(startx*width_over, starty*height_over, endx*width_over, endy*height_over);
	}
};

#endif /*UNITFORM_H_*/
