#include "GlutMain.h"
#include "graphic/updater/Updater.h"
#include "graphic/mng/FocusMng.h"
#include "graphic/mng/KeyMng.h"
#include "graphic/mng/MouseMng.h"

// static o̎
int GlutMain::running = 0;
double GlutMain::framerate;
double GlutMain::oneFrameTime;
double GlutMain::drawingRealTime;
int GlutMain::width;
int GlutMain::height;

//! Unit, Updater Manager
AppMng *GlutMain::appMng;
UnitMng *GlutMain::unitMng;
UpdaterMng *GlutMain::updaterMng;
WindowMng *GlutMain::windowMng;

using namespace std;

void disp()
{
	//printfunc
	GlutMain::update();
	GlutMain::draw();
	glutSwapBuffers();
}

void resize(int width, int height)
{
	cout << "callbackWindowSize w=" << width << " h=" << height << endl;
	GlutMain::width = width;
	GlutMain::height = height;
	GlutMain::windowMng->windowSizeChangeProc(width, height);

	glViewport(0, 0, (int)width, (int)height);
	
 	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(30.0, (double)width / (double)height, 10.0, 100.0);
	//gluPerspective(45, (GLfloat)width/(GLfloat)height, -100.0, 100.0);
	glMatrixMode(GL_MODELVIEW);
}

inline void update_key_modifier()
{
	int modifier = glutGetModifiers();
	KeyMng::getInstance()->SHIFT = (modifier & GLUT_ACTIVE_SHIFT) ? KEY_PRESS : KEY_RELEASE;
	KeyMng::getInstance()->CTRL  = (modifier & GLUT_ACTIVE_CTRL)  ? KEY_PRESS : KEY_RELEASE;
	KeyMng::getInstance()->ALT   = (modifier & GLUT_ACTIVE_ALT)   ? KEY_PRESS : KEY_RELEASE;
}

void mouse(int pos, int state, int x, int y)
{
	MouseMng::getInstance()->mousePosition(x, y);
	MouseMng::getInstance()->mouseButton(pos, state);
}

void motion(int x, int y)
{
	MouseMng::getInstance()->mousePosition(x, y);
}

void key(unsigned char key , int x , int y)
{
	printf("Glut Key = %c, (%d)\n" , key, (int)key);
	update_key_modifier();
	KeyMng::getInstance()->keyFunc((int)key, KEY_PRESS);
}

void keyup(unsigned char key , int x , int y)
{
	printf("Glut Key = %c, (%d)\n" , key, (int)key);
	update_key_modifier();
	KeyMng::getInstance()->keyFunc((int)key, KEY_RELEASE);
}

void special_key(int key , int x , int y)
{
	printf("Glut Special Key = %d\n" , key);
	update_key_modifier();
	KeyMng::getInstance()->keyFunc((int)key, KEY_PRESS);
}

void special_keyup(int key , int x , int y)
{
	printf("Glut Special Key up = %d\n" , key);
	update_key_modifier();
	KeyMng::getInstance()->keyFunc((int)key, KEY_RELEASE);
}

void GlutMain::Start()
{
	glutIdleFunc(disp);
	appMng->start(); // !! Appo^ɌĂяoȂƂȂ
	glutMainLoop();
}

/*!
 * \brief stop()Ăяostart()̉iv[v甲iIj
 */
void GlutMain::Stop(void)
{
	glutIdleFunc(0);
}

/*!
 * \brief 
 */
void GlutMain::Init(void)
{
	printfunc;

	//! p[^ݒ
	width = 1080;
	height = 640;
	framerate = 30; // ftHgEt[[gi30fpsj
	setFramerate(framerate);

	appMng = new AppMng();			//! AppMng
	unitMng = new UnitMng();		//! UnitMng
	updaterMng = new UpdaterMng();	//! UpdaterMng
	windowMng = new WindowMng();

	running = 0;

	glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGBA | GLUT_DEPTH);
	glutInitWindowPosition(100 , 50);
	glutInitWindowSize(width , height);

	glutCreateWindow("GridSynth");
	glutDisplayFunc(disp);
	glutMotionFunc(motion);
	glutReshapeFunc(resize);
	glutMouseFunc(mouse);
	
	glutKeyboardFunc(&key);
	glutSpecialFunc(&special_key);

	//! OpenGL̃p[^ݒ
	cout << "+ call glEnable() setting" << endl;
//	glDisable(GL_LINE_SMOOTH);
//	glDisable(GL_POLYGON_SMOOTH);
//	glDisable(GL_POINT_SMOOTH);
	glEnable(GL_LINE_SMOOTH);
	glEnable(GL_POLYGON_SMOOTH);
	glEnable(GL_POINT_SMOOTH);
	
	//! glBlendFuncƑp`ɐĂ܂
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	
	glShadeModel(GL_SMOOTH);
	
	cout << "+ call glViewport() setting" << endl;
	
	glViewport(0, 0, (int)width, (int)height);
	
 	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(30.0, (double)width / (double)height, 10.0, 100.0);
}

/*!
 * \brief ejbgUpdate
 */
void GlutMain::update()
{
	printfuncloop

	updaterMng->update();			//! Updateȑs
	updaterMng->updaterDeadCheck();	//! IUpdater`FbNč폜

	unitMng->update();				//! jbgUpdate
	appMng->update();				//! AppUpdate
}

/*!
 * \brief ejbg̕`
 */
void GlutMain::draw()
{
	printfuncloop
	glClearColor (1.f, 1.f, 1.f, 1.0f);	// clear the surface
	/*
	  imndrawłftdrawiFTGLj̕`悪łȂȂĂB
	  ˉʃNAȂŁAOtBbN̕`n߂OɂȂƂȂB
	*/
 	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	gluLookAt(0.0, 0.0, -40.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
	//gluLookAt(0, 0, 680, 0.0, 0.0, 0.0,  0.0, 1.0, 0.0);
	
	glColor3f(1, 0, 0);
	glBegin(GL_LINES);
	glVertex3f(0, 0, 0);
	glVertex3f(100, 0, 0);
	glEnd();
	
	glTranslatef(width/2, height/2, 0);
	
	unitMng->draw();					//! jbg̕`
	appMng->draw();						//! App̕`
 	/*!
 	 * łUpdater̍폜`FbNȂƁAUnitDeleteꂽ^C~OUpdaterdie()̃tO
 	 * ĂA폜Ȃ܂܎update()Ăяo
 	 * ˂̎UnitQƂƌł܂
 	 */
	updaterMng->updaterDeadCheck();	//! IUpdater`FbNč폜@jbg`Kv
}

/*!
 * \brief Appǉ
 */
void GlutMain::addApp(AppForm *app)
{
	appMng->addApp(app);
}

/*!
 * \brief jbgǉ
 */
void GlutMain::addUnit(Unit *unit)
{
	unitMng->addUnit(unit);
}

/*!
 * Updater̒ǉ
 */
void GlutMain::addUpdater(Updater *up)
{
	updaterMng->addUpdater(up);
}

void GlutMain::addWindowListener(WindowListener *wl)
{
	windowMng->addWindowListener(wl);
}

/*
 * \brief FPSXV
 */
void GlutMain::setFramerate(double fps)
{
	framerate = fps;
	oneFrameTime = 1.0 / fps;
}

/*!
 * Glutɐݒ肳ꂽFramerate擾
 */
float GlutMain::getFramerate()
{
	return framerate;
}

/*!
 * w肵Timet[ɂȂ邩Ԃ
 */
int GlutMain::timeToFrame(float time)
{
	int numFrame = (int)(time / oneFrameTime);
	return numFrame;
}



