/*
 * GridEventView.cpp
 *
 *  Created on: 2009/11/18
 *      Author: ox
 */

#include "GridEventView.h"

struct Layout {
	static Colorful areaColor;
	static Colorful areaHighColor;
	static Colorful trajColor;
	static Colorful trajHighColor;
};

Colorful Layout::areaColor 		(0.5, 0.5, 0.5, 0.4);
Colorful Layout::areaHighColor 	(1.0, 0.5, 0.5, 0.8);
Colorful Layout::trajColor 		(0.5, 0.5, 0.5, 0.4);
Colorful Layout::trajHighColor 	(1.0, 0.5, 0.5, 0.8);

//typedef GridEventView::GridAreaView GridAreaView;
//typedef GridEventView::GridTrajView GridTrajView;
//typedef GridEventView::GridViewVector GridViewVector;

GridEventView::GridEventView(GridFigureFactory &figureFactory, GridMaster &gridMaster) :
	figureFactory(figureFactory), gridMaster(gridMaster)
{
}

GridEventView::~GridEventView() {
	eventViewMutex.lock();
	for(map<int,EventViewVector*>::iterator itr = eventViewMap.begin(); itr != eventViewMap.end(); itr++) {
		((EventViewVector*)itr->second)->erase();
	}
	eventViewMutex.unlock();
}

//! w肵IDView\
void GridEventView::show(int eventID)
{
	eventViewMutex.lock();
	((EventViewVector*)eventViewMap[eventID])->show();
	eventViewMutex.unlock();
}

//! w肵IDView\ɂ
void GridEventView::hide(int eventID)
{
	eventViewMutex.lock();
	((EventViewVector*)eventViewMap[eventID])->hide();
	eventViewMutex.unlock();
}

//! o^Ă邷ׂĂView\
void GridEventView::show()
{
	eventViewMutex.lock();
	printfunc
	for(map<int,EventViewVector*>::iterator itr = eventViewMap.begin(); itr != eventViewMap.end(); itr++) {
		printfunc
		((EventViewVector*)itr->second)->show();
	}
	EventView::visible = true;
	eventViewMutex.unlock();
}

//! o^Ă邷ׂĂView\ɂ
void GridEventView::hide()
{
	eventViewMutex.lock();
	for(map<int,EventViewVector*>::iterator itr = eventViewMap.begin(); itr != eventViewMap.end(); itr++) {
		((EventViewVector*)itr->second)->hide();
	}
//	for(unsigned int i = 0; i < eventViews.size(); i++) {
//		eventViews.at(i)->hide();
//	}
	EventView::visible = false;
	eventViewMutex.unlock();
}

//! o^Ă邷ׂẴCxg̃[I[os
void GridEventView::point(int x, int y) {
	eventViewMutex.lock();
	for(map<int,EventViewVector*>::iterator itr = eventViewMap.begin(); itr != eventViewMap.end(); itr++) {
		((EventViewVector*)itr->second)->point(x, y);
	}
	eventViewMutex.unlock();
}

void GridEventView::select(int x, int y)
{

}

//! w肵ID̃Cxg̃r[폜
void GridEventView::remove(int eventID) {
	eventViewMutex.lock();
	hide(eventID);	//! eventIDɑΉView\
	EventViewVector *evv = eventViewMap[eventID];
	evv->erase();
	eventViewMap.erase(eventID);
	delete evv;
	eventViewMutex.unlock();
}

/*!
 * InputEvents̒őAŏlGA쐬Ao^
 */
void GridEventView::entryEvents(int eventID, vector<InputEvent> &inputEvents)
{
	printfunc
	eventViewMutex.lock();
	EventViewVector *evv = new EventViewVector();
	evv->areaView = new GridAreaView(figureFactory, inputEvents);			//! CxgAreaView쐬Eo^
	evv->vector.push_back(evv->areaView);				//! AreaViewVieŵЂƂƂēo^
	evv->vector.push_back(new GridTrajView(figureFactory, inputEvents));	//!

	eventViewMap.insert( map<int,EventViewVector*>::value_type(eventID, evv) );
	eventViewMutex.unlock();
}

//! PointedԂ̃CxgIDo
vector<int> GridEventView::getPointedEventIDs()
{
	eventViewMutex.lock();
	vector<int> pointedIDs;
	for(map<int,EventViewVector*>::iterator itr = eventViewMap.begin(); itr != eventViewMap.end(); itr++) {
		GridAreaView *gridAreaView = ((EventViewVector*)itr->second)->areaView;
		if(gridAreaView->isPointed()) {
			pointedIDs.push_back(itr->first);
		}
	}
	eventViewMutex.unlock();
	return pointedIDs;
}

/*!
 * EventViewVector
 */
void EventViewVector::show() {
	for(unsigned int i = 0; i < vector.size(); i++) {
		vector.at(i)->show();
	}
}

void EventViewVector::hide() {
	for(unsigned int i = 0; i < vector.size(); i++) {
		vector.at(i)->hide();
	}
}

void EventViewVector::erase() {
	for(unsigned int i = 0; i < vector.size(); i++) {
		vector.at(i)->hide();
		delete vector.at(i);
	}

	areaView->hide();
	delete areaView;
}

void EventViewVector::point(int x, int y) {

}

/*!
 * GridAreaView
 */
GridAreaView::GridAreaView(GridFigureFactory &figureFactory, vector<InputEvent> &inputEvents) :
	figureFactory(figureFactory),
	inputEvents(inputEvents),
	figure(0),
	rollovering(false),
	color(Layout::areaColor),
	highColor(Layout::areaHighColor)
{
	Area area;
	for(vector<InputEvent>::iterator itr = inputEvents.begin(); itr != inputEvents.end(); itr++) {
		InputEvent ie = *itr;
		if(ie.type == INPUT_TYPE_GRID) {
			if(ie.data1 > area.maxx) {	// SequenceInputEvent̂ȂōőmouseXlێ
				area.maxx = ie.data1;
			}
			if(ie.data1 < area.minx) {	// SequenceInputEvent̂ȂōŏmouseXlێ
				area.minx = ie.data1;
			}
			if(ie.data2 > area.maxy) {	// SequenceInputEvent̂ȂōőmouseXlێ
				area.maxy = ie.data2;
			}
			if(ie.data2 < area.miny) {	// SequenceInputEvent̂ȂōŏmouseXlێ
				area.miny = ie.data2;
			}
		}
	}
	this->area = area;
}

/*!
 * AreaɑΉGrid``
 */
void GridAreaView::show()
{
	printfunc
	if(!EventView::visible) {
		EventView::visible = true;

		//! View̃GA\``
		this->figure = figureFactory.drawArea(area.maxx, area.maxy, area.minx, area.miny, 0.2);

//		float gridx = figureFactory.toGridX(area.minx*width_over);
//		float gridy = figureFactory.toGridY(area.miny*height_over);
//		ftlabel *label = FTLabelFactory::getInstance()->simpleLabel(getAreaString(), gridx, gridy, 0.03);
//		label->setColor(Layout::GridAreaViewLabelColor);
//		GlutMain::addUnit(label);	// ς肱ꂪȂƂƏĂȂ
//		this->label = label;
	}
}

/*!
 * V[PX̃GA`Figure폜A`nh}bv菜
 * currentSequenceȂǁA܂o^ĂȂV[PX̏ꍇ͕`悹0Ԃ
 */
void GridAreaView::hide()
{
	if(EventView::visible) {
		EventView::visible = false;
		// `FigureCX^X
		if(figure) {
			figure->updateDelete(1);		// `Figure폜
			figure = 0;
		}

//		// `labelCX^X
//		if(label) {
//			label->updateDelete(1);		// label폜
//			label = 0;
//		}
	}
}

/*!
 * w肵W̃V[PXGAł邩H
 * \return `FύXꍇTRUE
 */
void GridAreaView::point(int x, int y)
{
	if(visible) {
		bool inArea = isArea(x, y);
		if(!rollovering && inArea) {	// GAɃ[I[o[ĂȂԂŁ˃[I[o
			rollovering = true;
			for(int i = 0; i < (int)figure->rects.size(); i++) {
				Rect *rect = figure->rects.at(i);
				rect->updateRed(1.0, 5);
			}
		} else if(rollovering && !inArea){	// GAɃ[I[o[ĂԂŁ˃[I[oO
			rollovering = false;
			for(int i = 0; i < (int)figure->rects.size(); i++) {
				Rect *rect = figure->rects.at(i);
				rect->updateRed(0.5, 5);	// ̐Fɖ߂
			}
		}
	}
}

void GridAreaView::select(int x, int y)
{

}

/*!
 * mouseX, mouseYseqInputAreał邩𔻒肷
 */
inline bool GridAreaView::isArea(int mouseX, int mouseY)
{
	bool inArea = false;
	if((mouseX <= area.maxx) && (mouseX >= area.minx) && (mouseY <= area.maxy) && (mouseY >= area.miny)) {
		inArea = true;
	}
	return inArea;
}




/*!
 * GridTrajView
 */
GridTrajView::GridTrajView(GridFigureFactory &figureFactory, vector<InputEvent> &inputEvents) :
	figureFactory(figureFactory),
	color(Layout::trajColor),
	highColor(Layout::trajHighColor)
{
	for(vector<InputEvent>::iterator itr = inputEvents.begin(); itr != inputEvents.end(); itr++) {
		InputEvent ie = *itr;
		if(ie.type == INPUT_TYPE_GRID) {
			this->inputEvents.push_back(ie);
		}
	}
}

void GridTrajView::show()
{
	printfunc
	gridTrajMutex.lock();
	if(inputEvents.size() > 0) {		// ̓Cxg
		visible = true;
		vector<InputEvent>::iterator itr = inputEvents.begin();
		InputEvent ie = *itr++;	// NԖڂ̓̓Cxgp
		InputEvent ie2;			//
		drawInputPoint(ie);		// 1Ԗڂ̃Cxg`
		for(; itr != inputEvents.end(); itr++) {
			ie2 = *itr;			// N+1Ԗڂ̓̓Cxgp
			drawCellLine(ie, ie2);	// N - N+1̓CxgԂŐ`悷
			drawInputPoint(ie2);	// N+1Ԗڂ̓̓|Cg`
			ie = ie2;
		}
	}
	gridTrajMutex.unlock();
}

void GridTrajView::hide()
{
	gridTrajMutex.lock();
	for(unsigned int i = 0; i < figureHandles.size(); i++) {
		CellFigureHandle *h = figureHandles.at(i);
		h->updateDelete(3);		// `撆̃IuWFNg
	}
	figureHandles.clear();		// `IuWFNg̃xN^NA
	visible = false;
	gridTrajMutex.unlock();
}

void GridTrajView::point(int x, int y)
{

}

void GridTrajView::select(int x, int y)
{

}

void GridTrajView::highlight(bool t)
{
	gridTrajMutex.lock();
	Colorful col = t ? highColor : color;
	for(unsigned int i = 0; i < figureHandles.size(); i++) {
		CellFigureHandle *h = figureHandles.at(i);
		h->setColor(col);		// `撆̃IuWFNg̐FύX
	}
	gridTrajMutex.unlock();
}

/*!
 * w肵sNZl܂Cell`
 */
inline void GridTrajView::drawInputPoint(InputEvent &ie)
{
	float alpha = 0.5;
	CellFigureHandle *handle1 = figureFactory.drawCell(ie.data1, ie.data2, 1, alpha, false);
	handle1->setColor(color);
	figureHandles.push_back(handle1);
}

/*!
 * w肵2_(ie1 -> ie2)Ȃ`
 */
inline void GridTrajView::drawCellLine(InputEvent &ie1, InputEvent &ie2)
{
	CellFigureHandle *lineHandle = figureFactory.drawConnection(ie1.data1, ie1.data2, ie2.data1, ie2.data2);
	lineHandle->setColor(color);
	figureHandles.push_back(lineHandle);
}


