/*
 * GridSheet.h
 *
 *  Created on: 2009/08/30
 *      Author: sambuichi
 */

#ifndef GRIDSHEET_H_
#define GRIDSHEET_H_

#include "GridMaster.h"
#include "MousePick.h"
#include "graphic/mng/WindowMng.h"
#include "graphic/primitive/Line.h"

class GridSheet :
	public GridMaster,
	public WindowListener
{
public:
	GridSheet(int row, int col, float width, float height, UnitMng *mng = GlutMain::getUnitMng());
	virtual ~GridSheet();

	void eraseSheet();
	void drawSheet();
	void windowSizeChanged(int width, int height);

	void mousePick(int x, int y, MousePick &mousePick);

private:
	vector<Line*> lines;
	float width, height;
	float gridAlpha;
	UnitMng *mng;
	bool drawing;

	void drawSelectionSheet();
	Line *addLine(float x, float y);
};

#endif /* GRIDSHEET_H_ */
