/*
 * InputEventManage.cpp
 *
 *  Created on: 2009/09/15
 *      Author: sambuichi
 */

#include "graphic/comp/InputEvents.h"

InputEvents::InputEvents() {
	// TODO ꂽRXgN^[EX^u

}

InputEvents::~InputEvents() {
	// TODO Auto-generated destructor stub
}

InputEvent InputEvents::get(int id)
{
	inputEventMutex.lock();
	InputEvent &ie = messageIDtoInputEventMap[id];
	inputEventMutex.unlock();
	return ie;
}

vector<InputEvent> InputEvents::get(vector<int> ids)
{
	vector<InputEvent> inputEventVector;
	inputEventMutex.lock();
	for(vector<int>::iterator itr = ids.begin(); itr != ids.end(); itr++) {
		if(messageIDtoInputEventMap.count(*itr)) {	// IDL[ƂCxg
			inputEventVector.push_back(messageIDtoInputEventMap[*itr]);
		}
	}
	inputEventMutex.unlock();
	return inputEventVector;
}


/*!
 * V[PT[ɒǉSkiniCxgɑ΂āAsequencerEventProcessed
 * R[obNp̃f[^iCxg_@ƂȂ̓f[^jǉ
 */
void InputEvents::put(int id, int type, int d1, int d2, int state, float time, float duration)
{
	inputEventMutex.lock();
	InputEvent ie;
	ie.id = id;
	ie.type = type;
	ie.data1 = d1;
	ie.data2 = d2;
	ie.state = state;
	ie.time = time;
	ie.duration = duration;
	messageIDtoInputEventMap.insert(map<int,InputEvent>::value_type(id, ie));
	inputEventMutex.unlock();
}

void InputEvents::remove(int id) {
	inputEventMutex.lock();
	messageIDtoInputEventMap.erase(id);	// Sequence::MessageɑΉInputEvent폜
	inputEventMutex.unlock();
}
