/*
 * InputEventManage.h
 *
 *  Created on: 2009/09/15
 *      Author: sambuichi
 */

#ifndef INPUTEVENTMANAGE_H_
#define INPUTEVENTMANAGE_H_

#include <map>
#include "common/Mutex.h"

#define INPUT_TYPE_NONE  0
#define INPUT_TYPE_MOUSE 1
#define INPUT_TYPE_KEY   2
#define INPUT_TYPE_GRID  3

#define INPUT_STATE_PRESS   0
#define INPUT_STATE_RELEASE 1
#define INPUT_STATE_MOUSE_DRUG    2

using namespace std;
using namespace stk;

class InputEvents {
public:
	struct InputEvent {
		int id;
		int type;
		int data1;
		int data2;
		int state;
		float time;
		float duration;
		InputEvent() :
			id(0), type(0), data1(0), data2(0), state(0), time(0), duration(0) {}
	};

	InputEvents();
	virtual ~InputEvents();

	InputEvent get(int id);
	vector<InputEvent> get(vector<int> ids);
	void put(int id, int type, int d1, int d2, int state, float time, float duration);
	void remove(int id);
	unsigned int size() { return messageIDtoInputEventMap.size(); }

	map<int,InputEvent> messageIDtoInputEventMap;		// key : Sequence::Message.id,  value : ΉInputEvent
private:
	Mutex inputEventMutex;
};

typedef InputEvents::InputEvent InputEvent;

#endif /* INPUTEVENTMANAGE_H_ */
