#include "KeyMng.h"
#include "graphic/GlutMain.h"
#include <typeinfo>

KeyMng *KeyMng::instance = 0;

KeyMng *KeyMng::getInstance(void)
{
	if(KeyMng::instance == 0) {
		cout << "keymng : new instance()" << endl;
		KeyMng::instance = new KeyMng();
	}
	return KeyMng::instance;
}

void KeyMng::global_keymapping(int key, KeyInputListener *kl)
{
	global_map.insert(map<int, KeyInputListener*>::value_type(key, kl));
}

void KeyMng::print_key_map()
{
	map<int, KeyInputListener*>::iterator itr2 = global_map.begin();

	cout << endl << "global key map list" << endl;
	while(itr2 != global_map.end()) {
  		cout << "  " << (char) itr2->first << "   ";
		if(itr2->second != NULL) {
			cout << typeid(*((KeyInputListener*)itr2->second)).name() << endl;
		}
		cout << endl;
		itr2++;
	}
}

void KeyMng::keyFunc(int key, int action)
{
	cout << "[keymng] key:" << key << "  action:" << action << endl;

	int ret = KEY_EVENT_SUCCESS;

	/* system key processing */
	switch(key) {
	case KEY_ENTER:
	case KEY_TAB:
//		if(KEY_CTRL && KEY_ALT) {
		if(KEY_CTRL) {
			if(action) {
				Unit *unit = dynamic_cast<Unit*> (FocusMng::getInstance()->getCurrent());
				if(unit) {
					cout << "   previous unit : " << unit->getName() << endl;
				}

				if(KEY_SHIFT) {	// ÕjbgɃtH[JX
					FocusMng::getInstance()->prevFocus(); // [FocusMng::changeFocus()]
				} else {		// ̃jbgɃtH[JX
					FocusMng::getInstance()->nextFocus(); // [FocusMng::changeFocus()]
				}

				unit = dynamic_cast<Unit*> (FocusMng::getInstance()->getCurrent());
				if(unit) {
					cout << "   next unit     : " << unit->getName() << endl;
				}
				return;
			}
		} else {
			ret = NO_SUCH_KEYEVENT;
		}
		break;
	case KEY_ESC:
		if(action)
			GlutMain::Stop();
		break;
	default:
		break;
	}

	/* current focus unit [FocusMng]*/
	focusunit_typecheck_func(KeyInputListener, keyFunc(key, action))

	/* global key_listener units */
	if(action) { // KEY_PRESSED
 		//cout << "keymng : func_call global keymap check" << endl;
		KeyInputListener *global_key_listener = global_map[key];
		if(global_key_listener) {
			global_key_listener->keyFunc(key, action);
		}
	}
}

