/*
 * Colorful.h
 *
 *  Created on: 2009/03/06
 *      Author: sambuichi
 */

#ifndef COLORFUL_H_
#define COLORFUL_H_

#include "ColorPort.h"
#include "graphic/DeadNotifier.h"
#include "graphic/updater/UpdaterGrPort.h"

class Colorful : public virtual DeadNotifier {
public:
	Colorful(float red = 0.5, float green = 0.5, float blue = 0.5, float alpha = 0.7);
	virtual ~Colorful();

	void setColor(const Colorful &color);

	void setColor(float r, float g, float b, float a);

	//! setter
	virtual void setR(float r);
	virtual void setG(float g);
	virtual void setB(float b);
	virtual void setA(float a);

	//! getter
	float getR() const;
	float getG() const;
	float getB() const;
	float getA() const;

	//! Updater
	void updateRed(float startVal, float endVal, unsigned int startFrame, unsigned int numFrame) {
		new UpdaterGrPort(new RPort(this), startVal, endVal, startFrame, numFrame);
	}
	void updateRed(float endVal, unsigned int numFrame) {
		new UpdaterGrPort(new RPort(this), r, endVal, 0, numFrame);
	}

	void updateGreen(float startVal, float endVal, unsigned int startFrame, unsigned int numFrame) {
		new UpdaterGrPort(new GPort(this), startVal, endVal, startFrame, numFrame);
	}
	void updateGreen(float endVal, unsigned int numFrame) {
		new UpdaterGrPort(new GPort(this), g, endVal, 0, numFrame);
	}

	void updateBlue(float startVal, float endVal, unsigned int startFrame, unsigned int numFrame) {
		new UpdaterGrPort(new BPort(this), startVal, endVal, startFrame, numFrame);
	}
	void updateBlue(float endVal, unsigned int numFrame) {
		new UpdaterGrPort(new BPort(this), b, endVal, 0, numFrame);
	}

	void updateAlpha(float startVal, float endVal, unsigned int startFrame, unsigned int numFrame) {
		new UpdaterGrPort(new APort(this), startVal, endVal, startFrame, numFrame);
	}
	void updateAlpha(float endVal, unsigned int numFrame) {
		new UpdaterGrPort(new APort(this), a, endVal, 0, numFrame);
	}

protected:
	float r, g, b, a;	//! color
};

#endif /* COLORFUL_H_ */
