/*
 * Resizable.h
 *
 *  Created on: 2009/03/07
 *      Author: sambuichi
 */

#ifndef RESIZABLE_H_
#define RESIZABLE_H_

#include "SizePort.h"
#include "graphic/DeadNotifier.h"
#include "graphic/updater/UpdaterGrPort.h"

class Resizable : public DeadNotifier {
public:
	Resizable(float size = 0.1);
	virtual ~Resizable();

	virtual void *setSize(const Resizable &resizable);
	virtual void setSize(float size);
	float getSize() const;
	float getSizePixel() const;

	void setWidth(float width);
	float getWidth() const;
	float getWidthPixel()const;

	void setHeight(float height);
	float getHeight() const;
	float getHeightPixel()const;

	//! Updater
	void updateSize(float startVal, float endVal, unsigned int startFrame, unsigned int numFrame) {
		new UpdaterGrPort(new SizePort(this), startVal, endVal, startFrame, numFrame);
	}
	void updateSize(float endVal, unsigned int numFrame) {
		new UpdaterGrPort(new SizePort(this), nsize, endVal, 0, numFrame);
	}

	void updateWidth(float startVal, float endVal, unsigned int startFrame, unsigned int numFrame) {
		new UpdaterGrPort(new WidthPort(this), startVal, endVal, startFrame, numFrame);
	}
	void updateWidth(float endVal, unsigned int numFrame) {
		new UpdaterGrPort(new WidthPort(this), width, endVal, 0, numFrame);
	}

	void updateHeight(float startVal, float endVal, unsigned int startFrame, unsigned int numFrame) {
		new UpdaterGrPort(new HeightPort(this), startVal, endVal, startFrame, numFrame);
	}
	void updateHeight(float endVal, unsigned int numFrame) {
		new UpdaterGrPort(new HeightPort(this), height, endVal, 0, numFrame);
	}



protected:
	/*!
	 * Normalized(0~1) Value
	 */
	float nsize;
	float width;
	float height;

	/*!
	 * Pixel Value
	 */
	float sizePixel, pixelSizeH;	//! size
	float widthPixel;
	float heightPixel;
};

#endif /* RESIZABLE_H_ */
