/*
 * SizePort.cpp
 *
 *  Created on: 2009/03/07
 *      Author: sambuichi
 */

#include "SizePort.h"
#include "Resizable.h"

/*!
 * ResizableSize|[g
 */
SizePort::SizePort(Resizable *resize, string name) : GrPort(resize, name) {
	this->resize = resize;
}

SizePort::~SizePort() {
}

float SizePort::get() {
	return resize->getSize();
}

void SizePort::set(float size) {
	resize->setSize(size);
}

/*!
 * ResizableWidth|[g
 */
WidthPort::WidthPort(Resizable *resize, string name) : GrPort(resize, name) {
	this->resize = resize;
}

WidthPort::~WidthPort() {
}

float WidthPort::get() {
	return resize->getWidth();
}

void WidthPort::set(float size) {
	resize->setWidth(size);
}

/*!
 * ResizableHeight|[g
 */
HeightPort::HeightPort(Resizable *resize, string name) : GrPort(resize, name) {
	this->resize = resize;
}

HeightPort::~HeightPort() {
}

float HeightPort::get() {
	return resize->getHeight();
}

void HeightPort::set(float size) {
	resize->setHeight(size);
}
