/*
 * RectTile.cpp
 *
 *  Created on: 2009/01/14
 *      Author: sambuichi
 */
#include "RectTile.h"
#include "graphic/GlutMain.h"
//#include "SynthController.h"
#ifdef _FTGL_ENABLE_
#include "graphic/text/ftlabel.h"
#include "graphic/text/FTLabelFactory.h"
#endif

RectTile::RectTile() : x(0), y(0) {
	DeclareName;
//	this->targetSynthChannel = -1;
	this->matrix_col = 3;
	this->matrix_row = 4;
	this->matrix_centerx = 0;
	this->matrix_centery = 0;
	this->matrix_sizex = 200;
	this->matrix_sizey = 150;
	this->msizex = 20;
	this->msizey = 15;
}

RectTile::~RectTile() {
	// TODO Auto-generated destructor stub
}

void RectTile::draw()
{
	if(!active) return;

	static float rr = 0;

	glPushMatrix();
	printunitfunc

	//! eGLp[^w
	glDisable(GL_CULL_FACE);		//! ʕ`
	glEnable(GL_LINE_SMOOTH);		//!
	glEnable(GL_POLYGON_SMOOTH);	//! |S`̋E炩ɂ
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
//	glEnable(GL_DEPTH_TEST);
	glDisable(GL_DEPTH_TEST);

	//! F̎w
	glColor4f(0.0f, 0.5f, 0.5f, 0.5f);

	//! glTranslatef, glRotatef֐glBegin-End̓ɏĂ͂Ȃ
	glTranslatef(matrix_centerx, matrix_centery, 0);

	glRotatef(mx, 0, 0, 1);
	glRotatef(my, 0, 1, 0);
	rr += 2;

	float matrix_startx = matrix_centerx - (matrix_sizex * 0.5);
	float matrix_starty = matrix_centery - (matrix_sizey * 0.5);
	float matrix_stepx = (matrix_sizex / (float) matrix_col);
	float matrix_stepy = (matrix_sizey / (float) matrix_row);

//	glBegin(GL_POLYGON);
//	glVertex3f(matrix_startx, matrix_starty, 0);
//	glVertex3f(-size, size, 0);
//	glVertex3f(-size, -size, 0);
//	glVertex3f(size, -size, 0);
//	glEnd();

	int matrix_rr_cnt = 0;
	for(int c = 0; c < matrix_col; c++) {
		for(int r = 0; r < matrix_row; r++) {
			glPushMatrix();
			glTranslatef(	matrix_startx + (matrix_stepx * c) + (matrix_stepx * 0.5),
							matrix_starty + (matrix_stepy * r) + (matrix_stepy * 0.5), 0);
			glRotatef(rr + matrix_rr_cnt * 4, 1, 0, 1);
			matrix_rr_cnt++;

//			glRectf(0, 0, matrix_stepx, matrix_stepy);
			glBegin(GL_POLYGON);
			glVertex3f(msizex, msizey, 0);
			glVertex3f(-msizex, msizey, 0);
			glVertex3f(-msizex, -msizey, 0);
			glVertex3f(msizex, -msizey, 0);
			glEnd();

			glPopMatrix();
		}
	}

	glRectf(matrix_startx, matrix_starty, matrix_startx + matrix_sizex, matrix_starty + matrix_sizey);
//	glRectf(-fw/2, -fh/2, fw/2, fh/2);

	glDisable(GL_LINE_SMOOTH);

	glPopMatrix();
}

void RectTile::mouseFunction(int x, int y, int state)
{
	printunitfuncmouse;
}

/*!
 * \brief }EXWlnhioverridej
 * ̃jbgɃtH[JXĂƂ̂݌Ăяo
 */
void RectTile::mousePosition(int x, int y)
{
	printunitfuncmouse;
	if(KeyMng::getInstance()->CTRL) {	//! Ctrl
		matrix_sizex = x;
		matrix_sizey = y;
	} else if(KeyMng::getInstance()->ALT) {
		msizex = (int)(x * 0.4);
		msizey = (int)(y * 0.4);
	} else {							//! L[CȂ
		mx = x;
		my = y;
	}
}

/*!
 * L[̓nhioverridej
 */
void RectTile::keyFunc(int key, int action)
{
	switch(key) {
#ifdef _FTGL_ENABLE_
	case GLUT_KEY_F1:	//! UnitHelp\
		// TODO HelpbZ[W\[`̒ǉĩjbg̑@\j
		//! labelIuWFNgŕ\
		GlutMain::addUnit(FTLabelFactory::getInstance()->unitHelpLabel(getName(), 0));
		GlutMain::addUnit(FTLabelFactory::getInstance()->unitHelpLabel("Ctrl+mouse     : ", 1));
		GlutMain::addUnit(FTLabelFactory::getInstance()->unitHelpLabel("Ctrl+Alt+mouse : ", 2));
		break;
#endif
	default:
		break;
	}
}

void RectTile::focusOn()
{
	this->active = true;
}

void RectTile::focusOff()
{
	this->active = false;
}

