/*
 * Shape.cpp
 *
 *  Created on: 2009/03/11
 *      Author: sambuichi
 */

#include "Shape.h"

Shape::Shape(ShapeAlign align, bool fill) :
	align(align), fill(fill)
{
}

Shape::~Shape() {
}

void Shape::copyShape(const Shape &shape)
{
	setFill(shape.getFill());
	setSize(shape);
	setPos(shape);
	setColor(shape);
}

void Shape::update()
{

}

void Shape::draw()
{
	glPushMatrix();

	glColor4f(r, g, b, a);
	//cout << pixelX << ", " << pixelY << ", " << pixelZ << endl;
	glTranslatef(pixelX, pixelY, pixelZ);

	//! virtual֐
	graphics();

	glPopMatrix();
}
