/*
 * Shape.h
 *
 *  Created on: 2009/03/11
 *      Author: sambuichi
 */

#ifndef SHAPE_H_
#define SHAPE_H_

#include "graphic/UnitForm.h"
#include "graphic/port/Positionable.h"
#include "graphic/GlutMain.h"

typedef enum {
	SHAPE_CENTER,
	SHAPE_CORNER_LEFT_TOP,
	SHAPE_CORNER_LEFT_BOTTOM
} ShapeAlign;

#include "graphic/UnitForm.h"
#include "graphic/port/Positionable.h"
#include "graphic/port/Resizable.h"
#include "graphic/port/Colorful.h"

class Shape:
	public UnitForm,
	public virtual Positionable,
	public virtual Resizable,
	public virtual Colorful
{
public:
	Shape(ShapeAlign align = SHAPE_CENTER, bool fill = true);
	virtual ~Shape();

	void update();
	void draw();
	virtual void graphics() = 0;
	void copyShape(const Shape &shape);

	//! zuACw
	void setAlign(ShapeAlign align) {
		this->align = align;
	}

	ShapeAlign getAlign() {
		return this->align;
	}

	//! hԂw
	void setFill(bool fill) {
		this->fill = fill;
	}

	bool getFill() const {
		return this->fill;
	}

protected:
	ShapeAlign align;
	bool fill;
};

#endif /* SHAPE_H_ */
