/*
 * ShapeFactory.h
 *
 *  Created on: 2009/04/01
 *      Author: sambuichi
 */

#ifndef SHAPEFACTORY_H_
#define SHAPEFACTORY_H_

class Rect;
class Circle;
class Connection;
class Positionable;

class ShapeFactory {
public:
	//! Singleton
	static ShapeFactory *getInstance()
	{
		static ShapeFactory *instance = 0;
		if(instance == 0) {
			instance = new ShapeFactory();
		}
		return instance;
	}
	virtual ~ShapeFactory();

	static Circle *smallRedPoint(float x, float y);

	static Connection *fadeLine(Positionable *p1, Positionable *p2);

private:
	ShapeFactory();
};

#endif /* SHAPEFACTORY_H_ */
