/*
 * FTLabelFactory.cpp
 *
 *  Created on: 2009/01/23
 *      Author: sambuichi
 */

#include "ftlabel.h"
#include "FTLabelFactory.h"
#include "graphic/updater/UpdaterKillUnit.h"

FTLabelFactory::FTLabelFactory() {
}

FTLabelFactory::~FTLabelFactory() {
}

/*!
 * \brief قƂǃftHg̃Vvȃx
 */
ftlabel *FTLabelFactory::simpleLabel(string label, float x, float y, float size, float r, float g, float b, float a)
{
	//! ftlabel
	int font_type 	= FTGL_PIXMAP;
	float posx		= x;	// default 0.5
	float posy		= y;	// default 0.5
	float red		= r;
	float green		= g;
	float blue		= b;
	float alpha		= a;
	FontAlign align = ALIGN_LEFT;
	return new ftlabel(label, font_type, size, posx, posy, align, red, green, blue, alpha);
}

/*!
 * \brief tH[JXĂUnitName\邽߂̃x쐬
 * ʍɏZ`
 */
ftlabel *FTLabelFactory::focusedUnitNameLabel(string label, float r, float g, float b, float a)
{
	//! ftlabel
	int font_type 	= FTGL_PIXMAP;
	float size		= 0.04;
	float posx		= 0.05;	// default 0.5
	float posy		= 0.95;	// default 0.5
	float red		= r;
	float green		= g;
	float blue		= b;
	float alpha		= a;
	FontAlign align = ALIGN_LEFT;
	return new ftlabel(label, font_type, size, posx, posy, align, red, green, blue, alpha);
}

/*!
 * \brief UnittH[JXςۂɕ\UnitNamep̃x쐬
 * ʒɑ傫\
 */
ftlabel *FTLabelFactory::focusChangeUnitNameLabel(string label, float r, float g, float b, float a)
{
	//! ftlabel
	int font_type 	= FTGL_PIXMAP;
	float size		= 0.125;
	float posx		= 0.5;	// default 0.5
	float posy		= 0.5;	// default 0.5
	float red		= r;
	float green		= g;
	float blue		= b;
	float alpha		= a;
	FontAlign align = ALIGN_CENTER;
	ftlabel *ftl = new ftlabel(label, font_type, size, posx, posy, align, red, green, blue, alpha);
	ftl->updateDelete(25);
	return ftl;
}

/*!
 * \brief MouseMonitorp̃x쐬
 * x̕\MouseMonitor瓮IɕύX
 */
ftlabel *FTLabelFactory::mouseMonitorLabel(string label)
{
	//! ftlabel
	int font_type 	= FTGL_PIXMAP;
	float size		= 0.03;
	float posx		= 0.95;	// default 0.5
	float posy		= 0.95;	// default 0.5
	float red		= 0.5;
	float green		= 0.5;
	float blue		= 0.5;
	float alpha		= 0.5;
	FontAlign align = ALIGN_RIGHT;
	return new ftlabel(label, font_type, size, posx, posy, align, red, green, blue, alpha);
}

/*!
 * \brief MouseMonitorp̃x쐬
 * x̕\MouseMonitor瓮IɕύX
 */
ftlabel *FTLabelFactory::unitParamMonitorLabel(int row)
{
	//! ftlabel
	int font_type 	= FTGL_PIXMAP;
	float size		= 0.03;
	float posx		= 0.95;				// default 0.5
	float posy		= 0.1 + 0.05 * row;	// default 0.5
	float red		= 0.5;
	float green		= 0.5;
	float blue		= 0.5;
	float alpha		= 0.5;
	FontAlign align = ALIGN_RIGHT;
	return new ftlabel("", font_type, size, posx, posy, align, red, green, blue, alpha);
}

/*!
 * \brief GrPortListp̃x쐬
 */
ftlabel *FTLabelFactory::grPortListLabel(string label, int row, int max_row)
{
	//! ftlabel
	int font_type 	= FTGL_PIXMAP;
	float size		= 0.05;
	float posx		= 0.3;				// default 0.5
	float posy		= 0.5 + 0.08 * (row - (max_row*0.5));	// default 0.5
	float red		= 0.5;
	float green		= 0.5;
	float blue		= 0.5;
	float alpha		= 0.5;
	FontAlign align = ALIGN_RIGHT;
	return new ftlabel(label, font_type, size, posx, posy, align, red, green, blue, alpha);
}

/*!
 * \brief SytListp̃x쐬
 */
ftlabel *FTLabelFactory::syListLabel(string label, int row, int max_row)
{
	//! ftlabel
	int font_type 	= FTGL_PIXMAP;
	float size		= 0.05;
	float posx		= 0.6;				// default 0.5
	float posy		= 0.5 + 0.08 * (row - (max_row*0.5));	// default 0.5
	float red		= 0.5;
	float green		= 0.5;
	float blue		= 0.5;
	float alpha		= 0.5;
	FontAlign align = ALIGN_LEFT;
	return new ftlabel(label, font_type, size, posx, posy, align, red, green, blue, alpha);
}

/*!
 * \brief ParameterListp̃x쐬
 */
ftlabel *FTLabelFactory::paramListLabel(string label, int row, int max_row, float listPosx, float listPosy)
{
	//! ftlabel
	int font_type 	= FTGL_PIXMAP;
	float size		= 0.04;
	float posx		= listPosx;
	float posy		= listPosy + 0.05 * (row);
	float red		= 0.5;
	float green		= 0.5;
	float blue		= 0.5;
	float alpha		= 0.5;
	FontAlign align = ALIGN_LEFT;
	return new ftlabel(label, font_type, size, posx, posy, align, red, green, blue, alpha);
}

/*!
 * \brief Grid|WV\p
 */
ftlabel *FTLabelFactory::gridPositionLabel(string label, float posx, float posy)
{
	//! ftlabel
	int font_type 	= FTGL_PIXMAP;
	float size		= 0.04;
	float red		= 0.5;
	float green		= 0.5;
	float blue		= 0.5;
	float alpha		= 0.5;
	FontAlign align = ALIGN_LEFT;
	return new ftlabel(label, font_type, size, posx, posy, align, red, green, blue, alpha);
}

/*!
 * Unit̃wv\iiwj
 */
ftlabel *FTLabelFactory::unitHelpLabel(string label, int row, float r, float g, float b, float a)
{
	//! ftlabel
	int font_type 	= FTGL_PIXMAP;
	float size		= 0.02;
	float posx		= 0.05;					// default 0.5
	float posy		= 0.25 + row * 0.05;	// default 0.5
	float red		= r;
	float green		= g;
	float blue		= b;
	float alpha		= a;
	FontAlign align = ALIGN_LEFT;
	return new ftlabel(label, font_type, size, posx, posy, align, red, green, blue, alpha);
}
