#include "ftdraw.h"

//#include <ft2build.h>
//#include FT_FREETYPE_H

#include "ftglfont.h"
#include "graphic/GlutMain.h"
//#include "graphic/common/Window.h"

ftdraw::ftdraw(char *fontfile, int fonttype)
{
	DeclareName;
	this->fontfile = fontfile;
	this->fonttype = fonttype;
	this->fontSize = DefaultFontSize;

//	setDrawOrigin(WND_BOTTOM_LEFT); b
//	setDrawOrigin(WND_CENTER);

	//! DEBUG 20090114 NftdrawjbgɃtH[JXĂƗ
	initFont();
}

ftdraw::~ftdraw()
{
//	wnd->removeWindowChangeListener(this);
}

void ftdraw::init()
{
	//! DEBUG 20090114 NftdrawjbgɃtH[JXĂƗ
//	initFont();
}

void ftdraw::initFont(void)
{
	switch(fonttype) {
	case FTGL_BITMAP:
		font = new FTGLBitmapFont(fontfile);
		fonttypename = "FTGLBitmapFont";
		break;
	case FTGL_PIXMAP:
		font = new FTGLPixmapFont(fontfile);
		fonttypename = "FTGLPixmapFont";
		break;
	case FTGL_OUTLINE:
		font = new FTGLOutlineFont(fontfile);
		fonttypename = "FTGLOutlineFont";
		break;
	case FTGL_POLYGON:
		font = new FTGLPolygonFont(fontfile);
		fonttypename = "FTGLPolygonFont";
		break;
	case FTGL_EXTRUDE:
		font = new FTGLExtrdFont(fontfile);
		fonttypename = "FTGLExtrdFont";
		break;
	case FTGL_TEXTURE:
		font = new FTGLTextureFont(fontfile);
		fonttypename = "FTGLTextureFont";
		break;
	default:
		font = new FTGLOutlineFont(fontfile);
		fonttypename = "FTGLOutlineFont";
		break;
	}

	bf = new ftbuffer(font);
	bf->setLineSpaceRatio(1.5f);
	//(info_bf.get_head())->str = fonttypename;

	if(font->Error()) {
		std::cout << "Fail to open font " << fontfile << std::endl;
	}

	if(!font->FaceSize(fontSize)) {
		std::cout << "Fail to set size " <<  std::endl;
		exit(1);
	}

	font->Depth(10);
	font->CharMap(ft_encoding_unicode);
}

void ftdraw::update()
{
// 	posx++;
// 	if(posx > 200) posx = 0;
}

void ftdraw::camera(void)
{
	//! debug 20090127 ftdraw̕`glRasterPos2Dł̕`ʒu̎w肪łȂȂĂoȌC
	float fw = GlutMain::width;
	float fh = GlutMain::height;
//	gluOrtho2D(0, fw, 0, fh);

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluOrtho2D(0, fw, 0, fh);

	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
}

void ftdraw::draw()
{
	glPushMatrix();
	glEnable(GL_CULL_FACE);
	glEnable(GL_FRONT);

//	glTranslatef(- (wnd->width/2), wnd->height/2, 0); // center

	switch(fonttype)
	{
		case FTGL_BITMAP:
		case FTGL_PIXMAP:
		case FTGL_OUTLINE:
		case FTGL_POLYGON:
			break;
		case FTGL_TEXTURE:
			glEnable(GL_TEXTURE_2D);
			glDisable(GL_DEPTH_TEST);
			glNormal3f(0.0, 0.0, 1.0);
			break;
	}

//	glRasterPos2f(0, wnd->height);
//	glTranslatef (0, wnd->height, 0.0); // left upper of screen

	bf->draw();

	glPopMatrix();
}

void ftdraw::keyFunc(int key, int action)
{
	printunitfunckey;

	// ** ȍ~A[X͂Ă**

	if(action == KEY_RELEASE) {
		return;
	}

	int ret = KEY_EVENT_SUCCESS;

	switch(key) {
	case GLUT_KEY_UP:
		if(KEY_SHIFT)
			nextFont(1);
		break;
	case GLUT_KEY_DOWN:
		if(KEY_SHIFT)
			nextFont(-1);
		break;
	case GLUT_KEY_F4:
		bf->debug_print_buffer();
		break;
	default:
		if(KEY_SHIFT) {
			ret = bf->keyin(key-32);
		} else {
			ret = bf->keyin(key);
		}
		break;
	}
}

void ftdraw::nextFont(int changeVal) {
	fonttype += changeVal;

	if(fonttype < 0) {
		fonttype = FTGL_NRFONTTYPE - 1;
	}
	if(fonttype >= FTGL_NRFONTTYPE) {
		fonttype = 0;
	}
	delete font;
	initFont();
}

void ftdraw::changeFont(char *fontfile, int fonttype)
{
	this->fontfile = fontfile;
	this->fonttype = fonttype;
	initFont();
}

void ftdraw::setFontSize(unsigned int size, unsigned int focusOffSize)
{
	this->fontSize = size;
	this->fontSizeFocusOff = focusOffSize;
}

unsigned int ftdraw::getFontSize()
{
	return this->fontSize;
}

void ftdraw::focusOn()
{
	printunitfuncfocus;
//	font->FaceSize(100, 10);
	font->FaceSize(fontSize);
}

void ftdraw::focusOff()
{
	printunitfuncfocus;
//	font->FaceSize(10, 10);
	font->FaceSize(fontSizeFocusOff);
}

/*!
 * \brief x̕`Wlݒ
 * !! ʒu͉ʍ̑Έʒu0~1̐KꂽlŎw肷
 */
void ftdraw::setPos(float posx, float posy)
{
	bf->setPos(posx, posy);
}

//void ftdraw::setWindow(Window *wnd)
//{
//	WindowHolder::setWindow(wnd);
//	wnd->addWindowChangeListener(this);
//}
//
//void ftdraw::windowChanged(Window *wnd, int x, int y, int width, int height)
//{
//	float mul = width / (float) originalWindowWidth;
//	int size = (int) (mul * fontSize);
//	if(!font->FaceSize(size)) {
//		cout << __FILE__ << " : Font Size Setting Error!!" << endl;
//	}
//}
