#ifndef _GLFW_TEXT_
#define _GLFW_TEXT_

#include "ftbuffer.h"
#include "graphic/UnitForm.h"
#include "graphic/mng/KeyMng.h"
#include "graphic/mng/MouseMng.h"

#define DefaultFontSize 40;

class ftdraw :
	public UnitForm,
	public KeyInputListener,
	public MouseListener
{
public:
    ftdraw(char *fontfile, int fonttype = FTGL_PIXMAP);
    ~ftdraw();

	void init();
	void update();
	void camera();
	void draw();

	void keyFunc(int key, int action);
	void focusOn();
	void focusOff();

	void setPos(float posx, float posy);
	void setFontSize(unsigned int fs, unsigned int focusOffSize = 0);
	unsigned int getFontSize();

private:
	ftbuffer *bf;
	FTFont *font;

	char *fontfile;
	int fonttype;
	std::string fonttypename;

	void initFont();
	void nextFont(int changeVal);
	void changeFont(char *fontfile, int fonttype);

	/* font size control */

	unsigned int originalWindowWidth; // EChE̕ω{ŃtHg̃TCYω
	unsigned int fontSize;
	unsigned int fontSizeFocusOff;
//	float drawFontSize;
};


#endif
