/*
 * ftglfont.cpp
 *
 *  Created on: 2009/01/26
 *      Author: sambuichi
 */

#include "ftglfont.h"
#include <GLUT/glut.h>

/*!
 * \brief draw
 */
void ftdrawstr2d(FTFont *font, const char *str, GLdouble x, GLdouble y, FontAlign align)
{
	glPushMatrix();

	switch(align) {
	case ALIGN_LEFT:
		glRasterPos2d(x, y);
		font->Render(str);
		break;
	case ALIGN_CENTER:
		ftdrawstr2dcenter(font, str, x, y);
		break;
	case ALIGN_RIGHT:
		ftdrawstr2dright(font, str, x, y);
		break;
	}

	glPopMatrix();
}

inline void ftdrawstr2dcenter(FTFont *font, const char *str, GLdouble x, GLdouble y)
{
	struct bbox bb;
	font->BBox(str, bb.llx, bb.lly, bb.llz, bb.urx, bb.ury, bb.urz);
	glRasterPos2d(x + (bb.llx - bb.urx)/2, y);
	font->Render(str);
}

inline void ftdrawstr2dright(FTFont *font, const char *str, GLdouble x, GLdouble y)
{
	struct bbox bb;
	font->BBox(str, bb.llx, bb.lly, bb.llz, bb.urx, bb.ury, bb.urz);
	glRasterPos2d(x + (bb.llx- bb.urx), y);
	font->Render(str);
}
