#ifndef _FTGLFONT_
#define _FTGLFONT_

#include <ftgl.h>

#include "FTGLExtrdFont.h"
#include "FTGLOutlineFont.h"
#include "FTGLPolygonFont.h"
#include "FTGLTextureFont.h"
#include "FTGLPixmapFont.h"
#include "FTGLBitmapFont.h"

#define FTGL_BITMAP 0
#define FTGL_PIXMAP 1
#define FTGL_OUTLINE 2
#define FTGL_POLYGON 3
#define FTGL_EXTRUDE 4
#define FTGL_TEXTURE 5
#define FTGL_NRFONTTYPE 6

#define FONT_FILE "data/frabk.ttf"

#define EDITING 1
#define INTERACTIVE 2

//! meta_string char type
typedef enum {
	METASTR_NORMAL,
	METASTR_SPACE,
	METASTR_BREAK,
} MetaStrCharType;
//#define METASTR_NORMAL      0x0
//#define METASTR_SPACE       0x2
//#define METASTR_BREAK       0x4

//! draw font align
typedef enum {
	ALIGN_LEFT,
	ALIGN_CENTER,
	ALIGN_RIGHT
} FontAlign;

typedef double GLdouble;

//! bbox
struct bbox
{
	float llx, lly, llz, urx, ury, urz;
};

void ftdrawstr2d(FTFont *font, const char *str, GLdouble x, GLdouble y, FontAlign align = ALIGN_LEFT);
void ftdrawstr2dcenter(FTFont *font, const char *str, GLdouble x, GLdouble y);
void ftdrawstr2dright(FTFont *font, const char *str, GLdouble x, GLdouble y);


#endif
