/*
 * ftlabel.cpp
 *
 *  Created on: 2009/01/18
 *      Author: sambuichi
 */

#include "ftlabel.h"
#include "FTFontBuilder.h"
#include "graphic/mng/MouseMng.h"
#include "graphic/GlutMain.h"

ftlabel::ftlabel(string label, int font_type, float size, float posx, float posy, FontAlign align,
		float red, float green, float blue, float alpha) :
	str(label), align(align)
{
	DeclareName;
//	this->cnt = 0;
	this->active = true;
	this->font = FTFontBuilder::getInstance()->createFont(font_type);
	setPos(posx, posy);
	setColor(red, green, blue, alpha);
	setSize(size);
//	font->FaceSize(size * GlutMain::height);
	font->CharMap(ft_encoding_unicode);
	font->Depth(10);
}

ftlabel::~ftlabel() {
	delete font;
}

void ftlabel::camera()
{
	if(active) {
		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();
		gluOrtho2D(0, fw, 0, fh);
		glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();
	}
}

void ftlabel::update()
{
//	if(active) {
//		//! fade@\On̏ꍇAlphalXV
//		if(fade) {
//			a = fv.get();
//		}
//	}
}

void ftlabel::draw()
{
	if(active) {
		glPushMatrix();

		glEnable(GL_CULL_FACE);
		glEnable(GL_FRONT);

//		//! I
//		if(life >= 0 && cnt++ >= life) {	//! life = -1 JE^[ŏIȂ
//			fv.back();				//! l̕ɖ߂
//			if(fv.nearStart()) {	//! قƂǏlɋ߂Â
//				die();
//			}
//		} else {
//			fv.forward();			//! ړIl̕ɐi߂
//		}
		glColor4f(r, g, b, a);

		/*!
		 * Positionableset\bh͉ʍƂ0~1̑Βlňʒuw
		 * 0.5x= 0pixel
		 * 1.0x= fw/2
		 * 0.0x=-fw/2
		 */
		ftdrawstr2d(font, str.c_str(), pixelX + fw * 0.5, pixelY + fh * 0.5, align);
//		ftdrawstr2d(font, str.c_str(), x, y, align);

		glPopMatrix();
	}
}

/*!
 * \brief active
 */
void ftlabel::setActive(bool active)
{
	this->active = active;
}

/*!
 * \brief ̃xŕ\镶ύX
 */
void ftlabel::setLabel(string str)
{
	this->str = str;
}

string ftlabel::getLabel()
{
	return str;
}

/*!
 * tHgTCYݒi0~1Klj
 */
void ftlabel::setSize(float size)
{
	this->nsize = size;
	this->sizePixel = nsize * GlutMain::height;
//	font->FaceSize((unsigned int)(size * GlutMain::height));
	font->FaceSize((unsigned int)sizePixel);
}

//! ݂̃x̕PixellŕԂ
float ftlabel::getLabelWidth()
{
	struct bbox bb;
	font->BBox(str.c_str(), bb.llx, bb.lly, bb.llz, bb.urx, bb.ury, bb.urz);
	return (bb.urx - bb.llx);
}

//! ݂̃x̍PixellŕԂ
float ftlabel::getLabelHeight()
{
	struct bbox bb;
	font->BBox(str.c_str(), bb.llx, bb.lly, bb.llz, bb.urx, bb.ury, bb.urz);
	return (bb.ury - bb.lly);
}

//! x, yPixell
bool ftlabel::isArea(float x, float y)
{
	struct bbox bb;
	font->BBox(str.c_str(), bb.llx, bb.lly, bb.llz, bb.urx, bb.ury, bb.urz);
	float w = (bb.urx - bb.llx);
	float h = (bb.ury - bb.lly);
	float nx = getX() * GlutMain::width;
	float ny = getY() * GlutMain::height;
	if(nx <= x && x <= (nx+w) && (ny-h) <= y && y <= ny) {
		return true;
	}
	return false;
}
