#include "common.h"
#include "ctrl/CtrlMovingRubber.h"
#include "ctrl/CtrlV.h"
#include "ctrl/CtrlD.h"
#include "app/grid/AppGridSynth.h"

using namespace std;

void handler_sigint(int sig)
{
	printf("sig int caught!\n");

	graphic_release();
	sound_release();

	exit(EXIT_FAILURE);
}

float rand_over;

void common_init(int argc, char *argv[])
{
	srand((unsigned int) time(NULL));
	rand_over = 1.0 / (float)RAND_MAX;
	if(SIG_ERR == signal(SIGINT, handler_sigint)) {
		printf("failed to set signal handler\n");
		exit(1);
	}
}

void app_init(int argc, char *argv[])
{
/*
	new CtrlMovingRubber();
	new CtrlV();
	new CtrlD();
*/
	cout << "initialize App" << endl;
	AppGridSynth *app = new AppGridSynth();
 	//app->loadSynth("Flute"); // Stki name
 	app->loadSynth("Moog"); // Stki name
//	app->loadSynth(vstiname.c_str());
// //	app->loadSynth("Crystal.dll", 4);
 	//app->loadSynth("Neon.dll");
// 	app->loadSynth("lazysnake.dll", 6);
}

int main(int argc, char *argv[])
{
	sound_main(argc, argv);
	graphic_main(argc, argv);
	
	common_init(argc, argv);
	app_init(argc, argv);

	sound_start();
	graphic_start();
	
	graphic_release();
	sound_release();

	return 0;
}
