#ifndef _ARPEGGIATOR_
#define _ARPEGGIATOR_

#include <vector>
#include <math.h>

using namespace std;

class Sequence;

#define MAX_ARP_LENGTH 32

#define ARP_1000 0x88888888
#define ARP_1010 0xaaaaaaaa
#define ARP_0010 0x22222222

//! 抽象Arp値クラス
class AbstructArpFunc {
public:
	AbstructArpFunc() {}
	//! ArpeggiatorのIndex番目に対応する値を返す
	virtual int getIndexValue(int index) = 0;
protected:
	int _value;
};

class ArpValueFunc : public AbstructArpFunc {
public:
	ArpValueFunc(int v) { _value = v;}
	int getIndexValue(int index) {
		return _value;
	}
};

class ArpRandomFunc : public AbstructArpFunc {
public:
	ArpRandomFunc(int max = 128, int min = 0) {
		setMaxValue(max);
		setMinValue(min);
	}
	int getIndexValue(int index);
	void setMaxValue(int max) {	this->maxValue = max;	}
	void setMinValue(int min) {	this->minValue = min;	}
protected:
	int maxValue;
	int minValue;
};

#define SCALE_OCTAVE 12
#define SCALE_MAJOR 0
#define SCALE_MINOR 1

class ArpNoteScaleFunc : public ArpRandomFunc {
public:
  ArpNoteScaleFunc(int scale, int max, int min)
		: ArpRandomFunc(max, min), scale(scale) {
	}
	int getIndexValue(int index);
protected:
	int scale;
};

class Arpeggiator {
public:
	Arpeggiator();
	~Arpeggiator();
	void setPattern(unsigned int pattern);
	void setPatternShift(unsigned int shift);
	void setPatternLength(unsigned int length);
	void apply(Sequence *seq);

	void setNoteFunc(AbstructArpFunc *noteFunc);
	void setVelocityFunc(AbstructArpFunc *velocityFunc);
	void setDurationFunc(AbstructArpFunc *durationFunc);

private:
/*
	int getNote(int index);
	int getVelocity(int index);
	int getDuration(int index);
*/
	unsigned int patternBits;
	unsigned int patternLength;
	unsigned int patternShift;

	unsigned int unitDiacritic; // minimam diac

	AbstructArpFunc *_note;
	AbstructArpFunc *_velocity;
	AbstructArpFunc *_duration;
/*
	NoteType noteType;
	int note;
	float noteOnOdds;
	float noteOnOddsTable[MAX_ARP_LENGTH];

	int velocity;
	int duration;
*/

};

#endif



