#include "Metro.h"
#include "SKINI.msg"
#include "common.h"
#include "RtStk.h"
#include "Sequence.h"

Metro::Metro(float tempo, float samplingRate, unsigned int diac)
	: tempo(tempo), samplingRate(samplingRate), diac(diac), currentTick(0), beatCount(0)
{
//	this->beatDuration = (1.0 / tempo) * 60;
//	this->diacDuration = beatDuration / (float)diac;
//	this->beatTickTime = (long)(beatDuration * samplingRate);
	setTempo(tempo);

	printfunc
	cout << "tempo : " << tempo << endl;
	cout << beatDuration << "    " << diac << endl;
	cout << getBeatDuration() << "    " << getDiacDuration() << endl;
}

Metro::~Metro()
{
	printfunc
	for(vector<Sequence*>::iterator itr = sequences.begin(); itr != sequences.end(); itr++) {
		delete (Sequence *) *itr;
	}
}

void Metro::setTempo(float tempo) {
	this->tempo = tempo;
	this->beatDuration = (1.0 / tempo) * 60;
	this->diacDuration = beatDuration / (float)diac;
	this->beatTickTime = (long)(beatDuration * samplingRate);
};

void Metro::beat(SortMessager &messager, long masterCount)
{
	currentTime = masterCount / RtStk::getInstance()->getSamplingRate();

	//! call MetroListener
	for(vector<MetroListener*>::iterator itr = metroListeners.begin(); itr != metroListeners.end(); itr++) {
		((MetroListener*)*itr)->metroEvent(this);
	}

	//! next Metro beat Event
	Skini::Message msg;
	msg.type = __SK_Metro_;
//	msg.time = currentTime + beatDuration; // tick time
	msg.time = currentTime + diacDuration; // tick time
	messager.pushMessage(msg);

	this->beatCount++;
	this->diacCount++;
	if(diacCount >= diac) {
		diacCount = 0;
	}
}

void Metro::start(SortMessager &messager, long masterCount)
{
	this->beatCount = 0;
	this->diacCount = 0;

	Skini::Message msg;
	msg.type = __SK_Metro_;
	this->currentTime = masterCount / RtStk::getInstance()->getSamplingRate();
	msg.time = currentTime; // sec time
	messager.pushMessage(msg);
}
