#ifndef _METRO_
#define _METRO_

#include <vector>
#include "Stk.h"
#include "Skini.h"
#include "SortMessager.h"
#include "common.h"

using namespace stk;
using namespace std;

class Sequence;
class Metro;

class MetroListener
{
public:
	MetroListener() {};
	virtual ~MetroListener() {};
	virtual void metroEvent(Metro *metro) = 0;
};

class Metro
{
public:
	Metro(float tempo, float samplingRate, unsigned int diac);
	~Metro();

	void start(SortMessager &messager, long masterCount);
	void beat(SortMessager &messager, long masterCount);

	void addMetroListener(MetroListener *metroListener) {
		metroListeners.push_back(metroListener);
	}

	long getCurrentTick() { return currentTick; }
	float getCurrentTime() { return currentTime; }
	float getBeatDuration() { return beatDuration; }
	float getDiacDuration() { return diacDuration; }
	unsigned int getBeatCount() { return beatCount; }
	float getTempo() { return tempo; };
	void setTempo(float tempo);

private:
	float tempo;
	float samplingRate;
	unsigned int diac;

	long currentTick;
	unsigned int beatCount;
	unsigned int diacCount;

	float currentTime;
	float beatDuration;
	float diacDuration;

	long beatTickTime;

	vector<Sequence*> sequences;
	vector<MetroListener*> metroListeners;
};


#endif
