#ifndef _MIXER_
#define _MIXER_

#include <vector>
#include "Ticker.h"
#include "Synth.h"

using namespace std;

class Effect {
public:
	virtual float tick(float in) = 0;
};

class Track : public Ticker {
public:
	Track();
	virtual ~Track() {}
//	Ticker *ticker;
	Synth *synth;
	float volume;
	vector<Effect*> effects;
	float tick(float **buffer, unsigned int channel, unsigned int num);
	int id;
private:
	static int idcnt;
};

class Mixer : public Ticker {
public:
	Mixer() : volume(1.0) {  cout << "Mixer" << endl; }
	virtual ~Mixer() {}
	vector<Track*> tracks;
	float tick(float **buffer, unsigned int channel, unsigned int num);

	void init(unsigned int channels, unsigned int bufferFrames);
	void add(Synth *synth);

private:
	unsigned int channels;
	unsigned int bufferFrames;
	float **frameBuffer;
	float volume;
};

#endif
