#ifndef __RT_STK__
#define __RT_STK__

#include "RtAudio.h"
#include "Mutex.h"
#include "Metro.h"
#include "Mixer.h"
#include "SortMessager.h"
#include "SKINI.msg"
#include "Skini.h"
#include <queue>

using namespace std;

#define RTSYNTH_SAMPLERATE 44100
//#define RTSYNTH_SAMPLERATE 44100
#define STK_RAWWAVE_PATH "./data/rawwaves/"

class RtStk
{
public:
	static RtStk *getInstance() {
		static RtStk *instance = NULL;
		if(instance == NULL) {
			instance = new RtStk(RTSYNTH_SAMPLERATE, 2, 80);
		}
		return instance;
	}
	~RtStk();

	int startDac();
	int openDac();
	int closeDac();

	void finish();

	SortMessager messager;
	Metro metro;
	Mixer mixer;

	long masterCount;
	double streamTime;
	int rtTick( void *outputBuffer, void *inputBuffer,
				unsigned int nBufferFrames, double streamTime);

	int getChannels() { return channels; }
	float getSamplingRate() { return sampleRate; }
	float getMasterVolume() { return volume; }
	unsigned int getBufferFrames() { return bufferFrames; }

private:
	RtStk(float sampleRate = RTSYNTH_SAMPLERATE, int channels = 2, float tempo = DEFAULT_TEMPO);

	void processMessage();

	RtAudio dac;
	float sampleRate;
	unsigned int bufferFrames;
	int channels;
	float volume;

	int counter;
	int peakCounter;
	bool haveMessage;
	bool done;
	Skini::Message message;

	float **frameBuffer;
	float **framePtr;
};

#endif // __RT_STK__
