#include "Sequence.h"
#include "SKINI.msg"
#include "common.h"
#include "RtStk.h"

#include <math.h>

int Sequence::idcnt = 0;
int Sequence::messageIDCount = 0;
map<int, int> Sequence::idToNoteMap;	// bZ[WIDƃm[gԍ̑ΉMAPiNoteOn/OFFpj

Sequence::Sequence(float tempo, unsigned int beat, unsigned int diacritic) :
	tempo(tempo), beat(beat), diacritic(diacritic), channel(0)
{
	this->length = 60.0f / tempo * beat;
	this->id = idcnt++;
}

Sequence::Sequence(Sequence &seq)
{
	cout << "Sequence : copy constructor" << endl;
	long copyCount = copyCnt();
	tempo = seq.tempo;
	beat = seq.beat;
	length = seq.length;
	for(vector<Sequence::Message>::iterator itr = seq.messages.begin(); itr != seq.messages.end(); itr++) {
		Sequence::Message msg = (Sequence::Message)*itr;
		if(msg.msg.type == __SK_NoteOnTag_ || msg.msg.type == __SK_NoteOffTag_) {
			msg.msg.intValues.at(0) += 0x10000 * copyCount;
		}
		msg.id = getNewMessageID();
		addMessage(msg);
	}
}

Sequence::~Sequence()
{
//	printfunc
}

//! Sequence static func
long Sequence::copyCnt() {
	static long cnt = 1;
	return cnt++;
}

//! Sequence static func
void Sequence::mapIDToNote(int id, int note) {
	idToNoteMap.insert(map<int,int>::value_type(id, note));
}

//! Sequence static func
int Sequence::getNoteFromID(int id) {
	map<int,int>::iterator itr = idToNoteMap.find(id);
	if( itr != idToNoteMap.end() ) {
		if(itr->second) {
			int value = itr->second;
			idToNoteMap.erase(itr);
			return value;
		}
	}
	return 0;
}

/*!
 * w肵Ԃ̃CxgsubseqɃRs[
 * ԂDacX^[g̎ԂŎw肷邪A
 * @V[PX̓V[PX̎n܂[Ƃ鎞ԊǗɂȂĂ̂
 * @DacX^[g̎ԂƃV[PXn܂Ƃ̕␳ԁitime_offsetjo
 * @ԂsubseqV[PXԂȂ̂ŁAMessagerȂǂŎgDacԂɕϊɂ
 * @time_offsetȂƂȂ
 * \return time_offset V[PXԁDACԂ̍
 */
float Sequence::subseq(Sequence &subseq, float start, float duration)
{
	float time_offset = 0;
	subseq.length = duration;

	if(start >= this->length) {
		int tmp = (int) (start / this->length);
		time_offset = tmp * this->length;
		start -= time_offset;
	}

	//! debug 20090909 subseqendʒu܂ԂĂȂ
	float end = start + duration;
	if(end >= this->length) {
		int tmp = (int) (end / this->length);
		end -= tmp * this->length;
		for(vector<Sequence::Message>::iterator itr = messages.begin(); itr != messages.end(); itr++) {
			Skini::Message msg = (*itr).msg;
			if(start <= msg.time) {	// debug 20090909
				subseq.addMessageHoldID(*itr);	// IWiIDێ܂
			} else if(msg.time < end) {
				Sequence::Message &smsg = subseq.addMessageHoldID(*itr);
				smsg.msg.time += this->length;
			}
		}
	} else {
		for(vector<Sequence::Message>::iterator itr = messages.begin(); itr != messages.end(); itr++) {
			Skini::Message msg = (*itr).msg;
			if(start <= msg.time && msg.time < end) {
				subseq.addMessageHoldID(*itr);	// IWiIDێ܂
			}
		}
	}
//	for(vector<Sequence::Message>::iterator itr = messages.begin(); itr != messages.end(); itr++) {
//		Skini::Message msg = (*itr).msg;
//		if(start <= msg.time && msg.time < (start + duration)) {
////			msg.time += time_offset;	// V[PXԁDACԂ̕ϊ
//			subseq.addMessageHoldID(*itr);	// IWiIDێ܂
//		}
//	}

//	cout << "subseq from : " << start << " to " << start * duration << endl;

	return time_offset;
}

vector<int> Sequence::getMessageIDs()
{
	vector<int> ids;
	for(vector<Sequence::Message>::iterator itr = messages.begin(); itr != messages.end(); itr++) {
		ids.push_back(((Sequence::Message)*itr).id);
	}
	return ids;
}

/*!
 * V[PXɃbZ[WǉiIDێj
 */
Sequence::Message &Sequence::addMessageHoldID(Sequence::Message &msg)
{
	messages.push_back(msg);
	return messages.back();	//ǉvf̎QƂԂ
}

inline int Sequence::getNewMessageID() {
	return messageIDCount++;	// bZ[W肷邽߂ID
}

/*!
 * V[PXɃbZ[Wǉ
 */
inline int Sequence::addMessage(Sequence::Message &msg)
{
	messages.push_back(msg);
	return msg.id;	//ǉvf̎QƂԂ
}

inline float Sequence::fmodTime(float time)
{
	if(time >= this->length) {
		time = fmod(time, this->length);
	}
	return time;
}

//! NoteOnbZ[Wǉ
int Sequence::addNoteOn(float note, float velocity, float time, int loop)
{
	Sequence::Message msg;

	msg.msg.type = __SK_NoteOnTag_;
	msg.msg.floatValues.at(0) = note;
	msg.msg.floatValues.at(1) = velocity;
	msg.msg.time = time;
	msg.msg.channel = this->channel;	//! bZ[W̃`ĺÃV[PXĂ`lԍg
	msg.msg.time = fmodTime(time);	//! SequencerƂ̑ΎԂŊǗĂ̂ŕϊ
	msg.loop = loop;
	msg.id = getNewMessageID();
	msg.msg.intValues.at(0) = msg.id;	// StkiNoteOnOff^OSkini::MessageɂID

	mapIDToNote(msg.id, (int)note);

	return addMessage(msg);
}

//! NoteOffbZ[Wǉ
int Sequence::addNoteOff(int noteOnID, float time, int loop)
{
	Sequence::Message msg;
	msg.msg.channel = this->channel;	//! bZ[W̃`ĺÃV[PXĂ`lԍg
	msg.msg.type = __SK_NoteOffTag_;
	msg.msg.time = fmodTime(time);
	msg.msg.floatValues.at(0) = getNoteFromID(noteOnID);
	msg.loop = loop;
	msg.id = getNewMessageID();
	msg.msg.intValues.at(0) = noteOnID;	// StkiNoteOnOff^OSkini::MessageɂID

	return addMessage(msg);
}

//! ControlChangebZ[Wǉ
int Sequence::addCC(float cc, float data, float time, int loop) {
	Sequence::Message msg;
	msg.msg.channel = this->channel;	//! bZ[W̃`ĺÃV[PXĂ`lԍg
	msg.msg.type = __SK_ControlChange_;
	msg.msg.time = fmodTime(time);
	msg.msg.floatValues.at(0) = cc;
	msg.msg.floatValues.at(1) = data;
	msg.loop = loop;
	msg.id = getNewMessageID();

	return addMessage(msg);
}


//! ԁisecjw肵Noteǉ
inline void Sequence::addNote(float note, float velocity, float time, float duration, int loop)
{
	int noteOnID = addNoteOn(note, velocity, time, loop);
//	long tag = msg.msg.intValues.at(SKINI_MSG_INT_NOTETAG);
	addNoteOff(noteOnID, time+duration, loop);
}

//! V[PX̃Xebvw肵Noteǉ
void Sequence::addNote(float note, float velocity, int beat, int diac, int diac_duration, int loop)
{
	cout << "Sequence::addNote" << endl;
	cout << " note : " << note << endl;
	cout << " velocity : " << velocity << endl;
	cout << " beat : " << beat << endl;
	cout << " diac : " << diac << endl;
	cout << " diac_duration : " << diac_duration << endl;

	float diac_beat = (float) diac / (float) this->diacritic;
	float time = (60.0f / tempo * (beat+diac_beat));
	float duration = (60.0f / tempo * ((float) diac_duration / (float) this->diacritic));
	addNote(note, velocity, time, duration, loop);
}

void Sequence::removeMessage(int id)
{
	for(vector<Sequence::Message>::iterator itr = messages.begin(); itr != messages.end(); itr++) {
		if(((Sequence::Message)*itr).id == id) {
			messages.erase(itr);
			return;
		}
	}
}

//! ̃V[PX̑SbZ[W폜
void Sequence::clear()
{
	messages.clear();
}

//! create random note
void Sequence::randomNote(int numNote, int noteWidth, int velocityWidth)
{
	clear();
	for(int i = 0; i < numNote; i++) {
		float note = 60 + (rand() % noteWidth) - (noteWidth / 2);
		float velo = 60 + (rand() % velocityWidth) - (velocityWidth / 2);
		int beat = rand() % this->beat;
		int diac = rand() % this->diacritic;
		int duration = (rand() % this->diacritic) + 1; // max duration is 1beat
		addNote(note, velo, beat, diac, duration);
	}
}

