#ifndef _SEQUENCE_
#define _SEQUENCE_

#include <vector>
#include <map>
#include "Skini.h"
#include "Metro.h"

using namespace stk;
using namespace std;

class Sequence
//class Sequence : public MetroListener
{
public:
	struct Message {
		Skini::Message msg;
		int id;
		int loop;
		Message() :
			id(0), loop(1) {}
	};

	Sequence(float tempo = 120, unsigned int beat = 8, unsigned int diacritic = 4);
	Sequence(Sequence &seq);
	~Sequence();

	int getID() { return id; }	//!	eV[PXňӂID
	int getChannel() { return channel; }		//! V[PX̑ΏۂƂȂVZ̃`l
	void setChannel(int channel) { this->channel = channel; }
	float getLength() { return this->length; }
	unsigned int getBeat() { return beat; }
	unsigned int getDiac() { return diacritic; }
	void setTempo(float tempo) { this->tempo = tempo; }
	void setBeat(unsigned int beat) { this->beat = beat; }
	vector<Sequence::Message> &getMessages() { return messages; }
	vector<int> getMessageIDs();

	float subseq(Sequence &subseq, float start, float duration);

	int addMessage(Sequence::Message &msg);
	Sequence::Message &addMessageHoldID(Sequence::Message &msg);
	int addNoteOn(float note, float velocity, float time, int loop = 1);
	int addNoteOff(int noteOnID, float time, int loop = 1);
	int addCC(float cc, float data, float time, int loop = 1);

	void addNote(float note, float velocity, float time, float duration, int loop = 1);
	void addNote(float note, float velocity, int beat, int diac, int diac_duration, int loop = 1);

	void randomNote(int numNote, int noteWidth = 12, int velocityWidth = 48);
	void clear();

	void removeMessage(int id);

	int size() { return messages.size(); }
	Sequence::Message &at(int num) { return messages.at(num); }

	float fmodTime(float time);

protected:
	Sequence::Message &NoteMessage(Sequence::Message &msg, float note, float vel, float time, float duration);

private:
	vector<Sequence::Message> messages;
	unsigned int id;
	float length;
	float tempo;
	unsigned int beat;
	unsigned int diacritic;
	int channel;

	int getNewMessageID();

	static long copyCnt();
	static int idcnt;
	static int messageIDCount;	// V[PXɒǉ郁bZ[WɈӂIDJEg

	static map<int, int> idToNoteMap;	// bZ[WIDƃm[gԍ̑ΉMAPiNoteOn/OFFpj
	static void mapIDToNote(int id, int note);
	static int getNoteFromID(int id);
};

#endif // _SEQUENCE_

