#include "SortMessager.h"

namespace stk {

SortMessager::SortMessager()
{

}

SortMessager::~SortMessager()
{
	mutex.lock();
	while(queue.size()) {
		queue.pop();
	}
	mutex.unlock();
}

void SortMessager::frontMessage(Skini::Message& message)
{
	if(queue.size() == 0) {
		message.type = 0;
		return;
	}
	mutex.lock();
	message = queue.top();
	mutex.unlock();
}

Skini::Message &SortMessager::pushMessage(Skini::Message& message)
{
	mutex.lock();
	Skini::Message &msg = queue.push(message);
	mutex.unlock();
	return msg;
}

void SortMessager::pop()
{
	if(queue.size() == 0) {
		return;
	}
	mutex.lock();
	queue.pop();
	mutex.unlock();
}

void SortMessager::popMessage(Skini::Message& message)
{
	if(queue.size() == 0) {
		message.type = 0;
		return;
	}
	mutex.lock();
	message = queue.top();
	queue.pop();
	mutex.unlock();
}

} // stk namespace
