/*
 * SynthFactory.cpp
 *
 *  Created on: 2009/08/17
 *      Author: O C
 */

#include "SynthFactory.h"
#include "common.h"
#include "Stki.h"

#ifdef __VSTI_ENABLE__
#include "VstiDir.h"
VstiDir *SynthFactory::vstidir = 0;
#endif

Synth* SynthFactory::synth_channel_map[NUM_SYNTH_CHANNEL] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

SynthFactory::SynthFactory() {
	// TODO ꂽRXgN^[EX^u

}

SynthFactory::~SynthFactory() {
	// TODO Auto-generated destructor stub
}

/*!
 * channel mapΉchannelSynthԂ
 * `l̏ꍇ0Ԃ
 */
Synth *SynthFactory::getSynthAt(unsigned int channel)
{
	return synth_channel_map[channel];
}

/*!
 * nameŎw肵StkSynth΁ÃCX^XԂ
 * StkSynthȂVstĩ[hāÃCX^XԂ
 * NULL : Synth쐬G[
 */
Synth *SynthFactory::create(const char *name, int voice)
{
	Synth *synth = createStki(name, voice);
#ifdef __VSTI_ENABLE__
	if(synth == NULL) {
		synth = createVsti(name);
	}
#endif
	return synth;
}

#ifdef __VSTI_ENABLE__
/*!
 * VstiSynth쐬
 */
Vsti *SynthFactory::createVsti(const char *name)
{
	if(vstidir == 0) {	// VSTi̒uꏊǗ
		vstidir = new VstiDir(DEFAULT_VSTI_DIR);
	}

	string path = vstidir->getPath(name);
	if(path.size() <= 0) {	// Ή閼OVSTi݂邩
		cout << "Error : SynthFactory::createVsti : cant find VSTi name="  << name << endl;
		return NULL;
	}

	Vsti *vsti = new Vsti(path.c_str());

	int channel_number = 0;
	if((channel_number = getEmptyChannelMapNumber()) < 0) {
		return NULL;	// `l̋󂫂Ȃ̂ŃG[
	}
	synthChannelMapping(vsti, channel_number);

	return vsti;
}
#endif

/*!
 * STK Synth̍쐬iOj
 * NULL : Synth쐬G[
 */
Stki *SynthFactory::createStki(const char *name, int voice)
{
	int instNumber = Stki::getStkInstNumber(name);
	if(instNumber < 0) {
		return NULL;
	}
	return createStki(instNumber, voice);
}

/*!
 * STK Synth̍쐬iInstԍj
 */
Stki *SynthFactory::createStki(int inst_num, int voice)
{
	int channel_number = 0;
	if((channel_number = getEmptyChannelMapNumber()) < 0) {
		return NULL;	// `l̋󂫂Ȃ̂ŃG[
	}
	string name(Stki::getStkInstName(inst_num));
	Stki *stki = new Stki(name);
	stki->setInstruments(inst_num, voice);
	synthChannelMapping(stki, channel_number);

	return stki;
}

/*!
 * Synthsynth_channel_mapɃ}bsO
 */
void SynthFactory::synthChannelMapping(Synth *synth, int channel_number)
{
	cout << "Synth : " << synth << "  channel map@: " << channel_number << endl;
	synth->setChannel(channel_number);
	synth_channel_map[channel_number] = synth;
}

/*!
 * synth_channel_map̋󂫔ԍԂ
 * -1F󂫂Ȃ
 */
int SynthFactory::getEmptyChannelMapNumber()
{
	int channel_number = 0;
	do {
		if(synth_channel_map[channel_number] == 0) {
			break;
		}
		channel_number++;
	} while(channel_number < NUM_SYNTH_CHANNEL);

	if(channel_number >= NUM_SYNTH_CHANNEL) {
		return -1;
	}
	return channel_number;
}
