/*
 * SynthFactory.h
 *
 *  Created on: 2009/08/17
 *      Author: O C
 */

#ifndef SYNTHFACTORY_H_
#define SYNTHFACTORY_H_

#include "Synth.h"
#include "Voicer.h"

#define NUM_SYNTH_CHANNEL 128

#ifdef __VSTI_ENABLE__
#define DEFAULT_VSTI_DIR  "vsti/"
#endif

class Stki;
#ifdef __VSTI_ENABLE__
class Vsti;
class VstiDir;
#endif

class SynthFactory {
public:
	SynthFactory();
	virtual ~SynthFactory();
	static Synth *create(const char *name, int voice = 4);
	static Synth *getSynthAt(unsigned int channel);

private:
	static Stki *createStki(const char *name, int voice);
	static Stki *createStki(int inst_num, int voice);
	static void synthChannelMapping(Synth *synth, int channel_number);
	static int getEmptyChannelMapNumber();

	static Synth *synth_channel_map[NUM_SYNTH_CHANNEL];

#ifdef __VSTI_ENABLE__
	static Vsti *createVsti(const char *path);
	static VstiDir *vstidir;
#endif
};

#endif /* SYNTHFACTORY_H_ */
