/*
 * SynthForm.h
 *
 *  Created on: 2009/08/18
 *      Author: sambuichi
 */

#ifndef SYNTHFORM_H_
#define SYNTHFORM_H_

#include <vector>
#include "common/Mutex.h"
#include "sound/SynthFactory.h"

// Listener Interface
class SynthChangedListener {
public:
	virtual void synthChanged(Synth *synth) = 0;
};

class SynthManager {
public:
	SynthManager();
	virtual ~SynthManager();

	void loadSynth(const char *name, int programNumber = 0);
	vector<Synth*> &getSynths() { return synths; }
	Synth *getCurrentSynth() { return currentSynth; }
	void setCurrentSynth(int i);

	void addSynthChangedListener(SynthChangedListener *synthChangedListener);

protected:
	vector<Synth*> synths;
	Synth *currentSynth;
	Mutex synthMutex;
	int channel;

private:
	vector<SynthChangedListener*> synthChangedListeners;
	void synthChangedCall(Synth *synth);
};

#endif /* SYNTHFORM_H_ */
