#include <stdio.h>
#include <math.h>

#include "Compressor.h"

static const char *inFile = "/Users/samb/Sound/raw/3FX00006.raw";
static const char *outFile = "./out.pcm";
static const int frameLength = 1024;

#define FRAME_LEN 1024

void Test_Compressor () {
	FILE *ofh, *ifh;
	int fl;
	//float wav[FRAME_LEN][2];
	float wav[FRAME_LEN*2];
	short buf[FRAME_LEN];
	
	if((ifh = fopen(inFile, "rb")) == NULL) {
		printf("input file open error %s\n", inFile);
		return;
	}
	
	if((ofh = fopen(outFile, "wb")) == NULL) {
		printf("output file open error %s\n", outFile);
		return;
	}

#if 0
	while(FRAME_LEN == (fl = fread(buf, sizeof(short), FRAME_LEN, ifh))) {
		for(int i = 0; i < FRAME_LEN; i++) {
			wav[i][0] = buf[i] / (float) 0x7FFF;
			wav[i][1] = wav[i][0];
		}
		
		compress(wav, FRAME_LEN, 50, 50, 44100, 100, 1000, 300, 1000);

		for(int i = 0; i < FRAME_LEN; i++) {
			buf[i] = (short)((wav[i][0] + wav[i][1]) * 0x3FFF);
		}
		fwrite(buf, sizeof(short), FRAME_LEN, ofh);
	}
#else
	while(FRAME_LEN == (fl = fread(buf, sizeof(short), FRAME_LEN, ifh))) {
		for(int i = 0; i < FRAME_LEN; i++) {
			wav[i*2  ] = buf[i] / (float) 0x7FFF;
			wav[i*2+1] = wav[i*2];
		}
		
		compress(wav, FRAME_LEN, 50, 50, 44100, 100, 1000, 300, 1000);

		for(int i = 0; i < FRAME_LEN; i++) {
			buf[i] = (short)((wav[i*2] + wav[i*2+1]) * 0x3FFF);
		}
		fwrite(buf, sizeof(short), FRAME_LEN, ofh);
	}
#endif
	fclose(ifh);
	fclose(ofh);
}

int main(int argc, char *argv[])
{
	// Test Routine
 	Test_Compressor();
	
	return 0;
}
