/*
 * The MIT License
 *
 * Copyright 2012 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package org.routine_work.notepad.prefs;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.content.res.Configuration;
import android.content.res.Resources;
import org.routine_work.notepad.R;
import org.routine_work.utils.Log;

/**
 *
 * @author Masahiko, SAWAI <masahiko.sawai@gmail.com>
 */
public class NotepadPreferenceUtils
{

	private static final String LOG_TAG = "simple-notepad";

	public static int getTheme(Context context)
	{
		int themeId = R.style.Theme_Notepad_Dark;

		String preferenceName = context.getPackageName() + "_preferences";
		SharedPreferences sharedPreferences = context.getSharedPreferences(preferenceName, Context.MODE_PRIVATE);
		String key = context.getString(R.string.notepad_theme_key);
		String defaultValue = context.getString(R.string.notepad_theme_default_value);
		String themeValue = sharedPreferences.getString(key, defaultValue);

		final String themeDark = context.getString(R.string.notepad_theme_dark_value);
		final String themeLight = context.getString(R.string.notepad_theme_light_value);
		if (themeDark.equals(themeValue))
		{
			themeId = R.style.Theme_Notepad_Dark;
		}
		else if (themeLight.equals(themeValue))
		{
			themeId = R.style.Theme_Notepad_Light;
		}

		return themeId;
	}

	public static boolean getActionBarAutoHide(Context context)
	{
		boolean actionBarAutoHide;
		int keyId;
		int defaultValueId;
		Log.v(LOG_TAG, "Hello");

		Resources resources = context.getResources();
		Configuration configuration = resources.getConfiguration();
		switch (configuration.orientation)
		{
			case Configuration.ORIENTATION_LANDSCAPE:
				keyId = R.string.actionbar_auto_hide_land_key;
				defaultValueId = R.bool.actionbar_auto_hide_land_default_value;
				break;
			default:
				keyId = R.string.actionbar_auto_hide_port_key;
				defaultValueId = R.bool.actionbar_auto_hide_port_default_value;
				break;
		}

		String preferenceName = context.getPackageName() + "_preferences";
		SharedPreferences sharedPreferences = context.getSharedPreferences(preferenceName, Context.MODE_PRIVATE);

		String key = resources.getString(keyId);
		boolean defaultValue = resources.getBoolean(defaultValueId);
		actionBarAutoHide = sharedPreferences.getBoolean(key, defaultValue);

		Log.v(LOG_TAG, "actionBarAutoHide => " + actionBarAutoHide);
		Log.v(LOG_TAG, "Bye");
		return actionBarAutoHide;
	}

	public static void reset(Context context)
	{
		Log.v(LOG_TAG, "Hello");

		String preferenceName = context.getPackageName() + "_preferences";
		SharedPreferences sharedPreferences = context.getSharedPreferences(preferenceName, Context.MODE_PRIVATE);
		Editor edit = sharedPreferences.edit();
		edit.clear();
		edit.commit();

		Log.v(LOG_TAG, "Bye");
	}
}
