package com.example.hello.android.actionbar_show_hide;

import android.app.ActionBar;
import android.app.Activity;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.WindowManager;
import android.widget.EditText;
import android.widget.Toast;

public class MainActivity extends Activity
	implements View.OnFocusChangeListener
{

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_ADJUST_RESIZE);
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main_activity);

		EditText textEditText = (EditText) findViewById(R.id.text_edittext);
		textEditText.setOnFocusChangeListener(this);
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu)
	{
		MenuInflater menuInflater = getMenuInflater();
		menuInflater.inflate(R.menu.main_activity_option_menu, menu);
		return true;
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item)
	{
		switch (item.getItemId())
		{
			case R.id.quit_menuitem:
				finish();
				break;
		}
		return super.onOptionsItemSelected(item);
	}

	public void onFocusChange(View view, boolean focused)
	{
		ActionBar actionBar = getActionBar();
		if (actionBar != null)
		{
			if (focused)
			{
				Toast.makeText(this, "ActionBar#hide()", Toast.LENGTH_SHORT).show();
				actionBar.hide();
			}
			else
			{
				Toast.makeText(this, "ActionBar#show()", Toast.LENGTH_SHORT).show();
				actionBar.show();
			}
		}
	}
}
