package com.example.hello.android.bitmap_drawing_and_save;

import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Environment;
import android.text.format.DateFormat;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.widget.Toast;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class MainActivity extends Activity
{

	private static final String LOG_TAG = "XXX";
	private static final String IMAGE_DIRECTORY_NAME = "save-bitmap-test";
	private static final File IMAGE_DIRECTORY_PATH = new File(Environment.getExternalStorageDirectory(), IMAGE_DIRECTORY_NAME);
	private CanvasView canvasView;

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		setTheme(android.R.style.Theme_NoTitleBar_Fullscreen);
		super.onCreate(savedInstanceState);

		canvasView = new CanvasView(this);
		setContentView(canvasView);
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu)
	{
		MenuInflater menuInflater = getMenuInflater();
		menuInflater.inflate(R.menu.save_menu, menu);
		menuInflater.inflate(R.menu.clear_menu, menu);
		menuInflater.inflate(R.menu.quit_menu, menu);

		return true;
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item)
	{
		boolean result = true;

		switch (item.getItemId())
		{
			case R.id.save_menuitem:
				new SaveImageTask().execute();
				break;
			case R.id.clear_menuitem:
				clearImage();
				break;
			case R.id.quit_menuitem:
				finish();
				break;
			default:
				result = super.onOptionsItemSelected(item);
		}

		return result;
	}

	private void saveImage()
	{
	}

	private void clearImage()
	{
		Log.v(LOG_TAG, "clearImage() : Hello");
		Canvas bitmapCanvas = canvasView.getBitmapCanvas();
		bitmapCanvas.drawARGB(0xff, 0, 0, 0);
		canvasView.invalidate();
		Log.v(LOG_TAG, "clearImage() : Hello");
	}

	class SaveImageTask extends AsyncTask<Void, Void, Void>
	{

		private File imageFilePath;

		@Override
		protected Void doInBackground(Void... paramss)
		{
			try
			{
				if (IMAGE_DIRECTORY_PATH.exists() == false)
				{
					Log.d(LOG_TAG, "saveImage() : create directory " + IMAGE_DIRECTORY_PATH);
					boolean result = IMAGE_DIRECTORY_PATH.mkdirs();
					Log.d(LOG_TAG, "saveImage() : mkdirs result " + result);
				}

				String basename = DateFormat.format("yyyyMMdd-hhmmss", System.currentTimeMillis()).toString();
				imageFilePath = new File(IMAGE_DIRECTORY_PATH, basename + ".png");
				Log.d(LOG_TAG, "saveImage() : filePath => " + imageFilePath);

				FileOutputStream fos = new FileOutputStream(imageFilePath);
				try
				{
					Bitmap bitmap = canvasView.getBitmap();
					bitmap.compress(Bitmap.CompressFormat.PNG, 80, fos);
				}
				finally
				{
					fos.close();
				}
			}
			catch (IOException ex)
			{
				Log.e(LOG_TAG, "saveImage() : file open failed.", ex);
			}
			return null;
		}

		@Override
		protected void onPostExecute(Void result)
		{
			String message = getString(R.string.image_saved_message, imageFilePath.getAbsolutePath());
			Toast.makeText(MainActivity.this, message, Toast.LENGTH_SHORT).show();
		}
	}
}
