/*
 * The MIT License
 *
 * Copyright 2014 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.example.hello.android.expandable_listview_hello;

import android.app.ExpandableListActivity;
import android.os.Bundle;
import android.util.Log;
import android.widget.SimpleExpandableListAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MainActivity extends ExpandableListActivity
{

	private static final String LOG_TAG = "XXX";
	private static final String MAPPING_KEY_CATEGORY = "Category";
	private static final String MAPPING_KEY_TITLE = "Title";
	private static final String MAPPING_KEY_AUTHOR = "Author";
	private static final String[] GROUP_MAPPING_FROM = new String[]
	{
		MAPPING_KEY_CATEGORY
	};
	private static final int[] GROUP_MAPPING_TO = new int[]
	{
		android.R.id.text1
	};
	private static final String[] CHILD_MAPPING_FROM = new String[]
	{
		MAPPING_KEY_TITLE,
		MAPPING_KEY_AUTHOR,
	};
	private static final int[] CHILD_MAPPING_TO = new int[]
	{
		android.R.id.text1,
		android.R.id.text2,
	};
	private static final int CATEGORY_COUNT = 5;
	private static final int BOOKS_PER_CATEGORY_COUNT = 4;
	private List<Map<String, String>> groupList;
	private List<List<Map<String, String>>> childList;

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		Log.v(LOG_TAG, "onCreate() : Hello");

		super.onCreate(savedInstanceState);
		setContentView(R.layout.main_activity);

		// Init SimpleExpandableListAdapter
		SimpleExpandableListAdapter adapter = new SimpleExpandableListAdapter(this,
			getGroupList(),
			android.R.layout.simple_expandable_list_item_1,
			GROUP_MAPPING_FROM,
			GROUP_MAPPING_TO,
			getChildList(),
			android.R.layout.simple_expandable_list_item_2,
			CHILD_MAPPING_FROM,
			CHILD_MAPPING_TO);

		setListAdapter(adapter);

		Log.v(LOG_TAG, "onCreate() : Bye");
	}

	private List<Map<String, String>> getGroupList()
	{
		if (groupList == null)
		{
			groupList = new ArrayList<Map<String, String>>();
			for (int i = 0; i < CATEGORY_COUNT; i++)
			{
				Map<String, String> categoryData = new HashMap<String, String>();
				categoryData.put(MAPPING_KEY_CATEGORY, String.format("Category-%02d", i));
				groupList.add(categoryData);
			}
		}
		return groupList;
	}

	private List<List<Map<String, String>>> getChildList()
	{
		if (childList == null)
		{
			childList = new ArrayList<List<Map<String, String>>>();
			for (int i = 0; i < CATEGORY_COUNT; i++)
			{
				List<Map<String, String>> booksInCategoryList = new ArrayList<Map<String, String>>();
				for (int j = 0; j < BOOKS_PER_CATEGORY_COUNT; j++)
				{
					Map<String, String> bookData = new HashMap<String, String>();
					bookData.put(MAPPING_KEY_TITLE, String.format("Title-%02d", j));
					bookData.put(MAPPING_KEY_AUTHOR, String.format("Author-%02d", j));
					booksInCategoryList.add(bookData);
				}
				childList.add(booksInCategoryList);
			}
		}
		return childList;
	}
}
